/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.acl;

import java.util.Vector;
import org.alfresco.jlan.server.auth.acl.AccessControl;
import org.alfresco.jlan.server.auth.acl.InvalidACLTypeException;

public class AccessControlList {
    private Vector<AccessControl> m_list = new Vector();
    private int m_defaultAccess = 2;

    public final int getDefaultAccessLevel() {
        return this.m_defaultAccess;
    }

    public final void setDefaultAccessLevel(int level) throws InvalidACLTypeException {
        if (level < 0 || level > 2) {
            throw new InvalidACLTypeException();
        }
        this.m_defaultAccess = level;
    }

    public final void addControl(AccessControl accCtrl) {
        this.m_list.add(accCtrl);
    }

    public final AccessControl getControlAt(int idx) {
        if (idx < 0 || idx >= this.m_list.size()) {
            return null;
        }
        return this.m_list.get(idx);
    }

    public final int numberOfControls() {
        return this.m_list.size();
    }

    public final void removeAllControls() {
        this.m_list.removeAllElements();
    }

    public final AccessControl removeControl(int idx) {
        if (idx < 0 || idx >= this.m_list.size()) {
            return null;
        }
        return this.m_list.remove(idx);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.m_list.size());
        str.append(":");
        str.append(":");
        str.append(AccessControl.asAccessString(this.getDefaultAccessLevel()));
        str.append(":");
        for (int i = 0; i < this.m_list.size(); ++i) {
            AccessControl ctrl = this.m_list.get(i);
            str.append(ctrl.toString());
            str.append(",");
        }
        str.append("]");
        return str.toString();
    }
}

