/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.alfresco.jlan.server.PacketHandlerInterface;

public abstract class SocketPacketHandler
implements PacketHandlerInterface {
    private Socket m_socket;
    private DataInputStream m_in;
    private DataOutputStream m_out;

    protected SocketPacketHandler(Socket socket) throws IOException {
        this.m_socket = socket;
        this.m_in = new DataInputStream(this.m_socket.getInputStream());
        this.m_out = new DataOutputStream(this.m_socket.getOutputStream());
    }

    @Override
    public abstract String getProtocolName();

    @Override
    public int availableBytes() throws IOException {
        if (this.m_in != null) {
            return this.m_in.available();
        }
        return 0;
    }

    @Override
    public int readPacket(byte[] pkt, int offset, int maxLen) throws IOException {
        if (this.m_in != null) {
            return this.m_in.read(pkt, offset, maxLen);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePacket(byte[] pkt, int offset, int len) throws IOException {
        if (this.m_out != null) {
            DataOutputStream dataOutputStream = this.m_out;
            synchronized (dataOutputStream) {
                this.m_out.write(pkt, offset, len);
            }
        }
    }

    @Override
    public void closePacketHandler() {
        if (this.m_socket != null) {
            try {
                this.m_socket.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.m_socket = null;
        }
        if (this.m_in != null) {
            try {
                this.m_in.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.m_in = null;
        }
        if (this.m_out != null) {
            try {
                this.m_out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_out = null;
        }
    }

    protected final Socket getSocket() {
        return this.m_socket;
    }
}

