/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.service.utils.normalizers;

import nc.ird.cantharella.data.model.ResultatTestBio;
import nc.ird.cantharella.data.model.TestBio;
import nc.ird.cantharella.service.utils.normalizers.UniqueFieldNormalizer;
import nc.ird.cantharella.service.utils.normalizers.utils.Normalizer;
import nc.ird.cantharella.utils.AssertTools;
import nc.ird.cantharella.utils.StringTransformer;

public final class TestBioNormalizer
extends Normalizer<TestBio> {
    @Override
    protected TestBio normalize(TestBio testBio) {
        AssertTools.assertNotNull((Object)testBio);
        testBio.setRef(Normalizer.normalize(UniqueFieldNormalizer.class, testBio.getRef()));
        testBio.setOrganismeTesteur(new StringTransformer(testBio.getOrganismeTesteur()).replaceConsecutiveWhitespaces().trimToNull().capitalizeFully().toString());
        for (ResultatTestBio curResult : testBio.getResultats()) {
            curResult.setRepere(Normalizer.normalize(UniqueFieldNormalizer.class, curResult.getRepere()));
            curResult.setProduitTemoin(new StringTransformer(curResult.getProduitTemoin()).replaceConsecutiveWhitespaces().trimToNull().capitalizeFully().toString());
        }
        return testBio;
    }
}

