package fr.reseaumexico.model;

public abstract class DistributionParameter extends AbstractMexicoBean {

    private static final long serialVersionUID = 3834924162866231096L;

    public static final String PROPERTY_NAME = "name";

    public static final String PROPERTY_VALUE = "value";

    public static final String PROPERTY_VALUE_TYPE = "valueType";

    protected String name;

    protected Object value;

    protected ValueType valueType;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        String oldValue = getName();
        this.name = name;
        firePropertyChange(PROPERTY_NAME, oldValue, name);
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        Object oldValue = getValue();
        this.value = value;
        firePropertyChange(PROPERTY_VALUE, oldValue, value);
    }

    public ValueType getValueType() {
        return valueType;
    }

    public void setValueType(ValueType valueType) {
        ValueType oldValue = getValueType();
        this.valueType = valueType;
        firePropertyChange(PROPERTY_VALUE_TYPE, oldValue, valueType);
    }

} //DistributionParameter
