/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.editor.factorValue;

import com.google.common.collect.Maps;
import fr.reseaumexico.editor.factorValue.FactorValueEditor;
import fr.reseaumexico.model.Domain;
import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.ValueType;
import java.awt.Component;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import jaxx.runtime.swing.editor.NumberEditor;

public class FactorValueEditorFactory {
    protected Map<Factor, FactorValueCellEditor<?>> factorValueEditorCache = Maps.newHashMap();

    public FactorValueEditor getDialogEditor(Factor factor, Object value) {
        return null;
    }

    protected FactorValueCellEditor<?> getFactorValueCellEditor(Factor factor) {
        return this.factorValueEditorCache.get(factor);
    }

    protected void setFactorValueCellEditor(Factor factor, FactorValueCellEditor<?> editor) {
        this.factorValueEditorCache.put(factor, editor);
    }

    public FactorValueCellEditor getCellEditor(Factor factor, Object value) {
        FactorValueCellEditor<Integer> factorValueCellEditor = this.getFactorValueCellEditor(factor);
        Domain domain = factor.getDomain();
        ValueType valueType = ValueType.STRING;
        if (domain != null) {
            valueType = domain.getValueType();
        }
        if (factorValueCellEditor == null) {
            switch (valueType) {
                case INTEGER: {
                    factorValueCellEditor = new IntegerFactorValueInlineEditor();
                    break;
                }
                case DECIMAL: {
                    factorValueCellEditor = new DecimalFactorValueInlineEditor();
                    break;
                }
                case BOOLEAN: {
                    factorValueCellEditor = new BooleanFactorValueInlineEditor();
                    break;
                }
                default: {
                    factorValueCellEditor = new DefaultFactorValueInlineEditor();
                }
            }
        }
        this.setFactorValueCellEditor(factor, factorValueCellEditor);
        factorValueCellEditor.setValue(value);
        return factorValueCellEditor;
    }

    public FactorValueCellRenderer getRenderedComponent(Factor factor, Object value) {
        return this.getCellEditor(factor, value);
    }

    public void clearCache() {
        this.factorValueEditorCache = Maps.newHashMap();
    }

    protected static String getStringValue(Object value) {
        String text = String.valueOf(value);
        if (value == null) {
            text = "";
        }
        return text;
    }

    protected static class DecimalFactorValueInlineEditor
    implements FactorValueCellEditor<Double> {
        protected NumberEditor numberEditor = new NumberEditor();

        public DecimalFactorValueInlineEditor() {
            this.numberEditor.getTextField().setBorder(null);
            this.numberEditor.setModelType(Double.class);
            this.numberEditor.setUseFloat(Boolean.valueOf(true));
            this.numberEditor.setUseSign(Boolean.valueOf(true));
        }

        @Override
        public Double getValue() {
            return (Double)this.numberEditor.getModel();
        }

        @Override
        public void setValue(Object value) {
            this.numberEditor.setModel((Number)((Double)value));
            this.numberEditor.setModelText(FactorValueEditorFactory.getStringValue(value));
        }

        @Override
        public Component getComponent() {
            return this.numberEditor;
        }
    }

    protected static class IntegerFactorValueInlineEditor
    implements FactorValueCellEditor<Integer> {
        protected NumberEditor numberEditor = new NumberEditor();

        public IntegerFactorValueInlineEditor() {
            this.numberEditor.getTextField().setBorder(null);
            this.numberEditor.setUseFloat(Boolean.valueOf(false));
            this.numberEditor.setUseSign(Boolean.valueOf(true));
        }

        @Override
        public Integer getValue() {
            return (Integer)this.numberEditor.getModel();
        }

        @Override
        public void setValue(Object value) {
            this.numberEditor.setModel((Number)((Integer)value));
            this.numberEditor.setModelText(FactorValueEditorFactory.getStringValue(value));
        }

        @Override
        public Component getComponent() {
            return this.numberEditor;
        }
    }

    protected static class BooleanFactorValueInlineEditor
    implements FactorValueCellEditor<Boolean> {
        protected JCheckBox checkBox = new JCheckBox();

        @Override
        public Boolean getValue() {
            return this.checkBox.isSelected();
        }

        @Override
        public void setValue(Object value) {
            if (value != null) {
                this.checkBox.setSelected((Boolean)value);
            }
        }

        @Override
        public Component getComponent() {
            return this.checkBox;
        }
    }

    protected static class DefaultFactorValueInlineEditor
    implements FactorValueCellEditor<String> {
        protected JTextField component = new JTextField();

        public DefaultFactorValueInlineEditor() {
            this.component.setBorder(null);
        }

        @Override
        public void setValue(Object value) {
            this.component.setText(FactorValueEditorFactory.getStringValue(value));
        }

        @Override
        public String getValue() {
            return this.component.getText();
        }

        @Override
        public Component getComponent() {
            return this.component;
        }
    }

    public static interface FactorValueCellEditor<B>
    extends FactorValueCellRenderer {
        public B getValue();

        @Override
        public void setValue(Object var1);

        @Override
        public Component getComponent();
    }

    public static interface FactorValueCellRenderer {
        public Component getComponent();

        public void setValue(Object var1);
    }
}

