/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.editor;

import com.google.common.collect.Lists;
import fr.reseaumexico.model.Factor;
import fr.reseaumexico.model.InputDesign;
import fr.reseaumexico.model.MexicoUtil;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.ValueType;
import fr.reseaumexico.model.event.InputDesignScenarioEvent;
import fr.reseaumexico.model.event.InputDesignScenarioListener;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.i18n.I18n;

public class InputDesignEditorModel
extends AbstractSerializableBean
implements InputDesignScenarioListener {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_INPUT_DESIGN = "inputDesign";
    public static final String PROPERTY_SCENARIO_EXISTS = "scenarioExists";
    protected InputDesign inputDesign;
    protected List<Factor> factors;
    protected final AbstractTableModel tableModel = new InputDesignTableModel();

    public InputDesign getInputDesign() {
        return this.inputDesign;
    }

    public boolean isScenarioExists() {
        return this.inputDesign != null && CollectionUtils.isNotEmpty((Collection)this.inputDesign.getScenario());
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public List<Factor> getFactors() {
        return this.factors;
    }

    public void setInputDesign(InputDesign inputDesign) {
        InputDesign oldValue = this.inputDesign;
        if (oldValue != null) {
            inputDesign.removeInputDesignScenarioListener((InputDesignScenarioListener)this);
        }
        this.inputDesign = inputDesign;
        inputDesign.addInputDesignScenarioListener((InputDesignScenarioListener)this);
        this.factors = Lists.newLinkedList((Iterable)inputDesign.getExperimentDesign().getFactor());
        this.firePropertyChange(PROPERTY_INPUT_DESIGN, oldValue, inputDesign);
        this.fireScenarioModified();
    }

    public void scenarioAdded(InputDesignScenarioEvent event) {
        this.fireScenarioModified();
    }

    public void scenarioRemoved(InputDesignScenarioEvent event) {
        this.fireScenarioModified();
    }

    public void scenarioRenamed(InputDesignScenarioEvent event) {
        this.fireScenarioModified();
    }

    public Collection<Scenario> getScenario() {
        return this.inputDesign == null ? null : this.inputDesign.getScenario();
    }

    protected void fireScenarioModified() {
        this.firePropertyChange(PROPERTY_SCENARIO_EXISTS, null, this.isScenarioExists());
        this.tableModel.fireTableStructureChanged();
    }

    protected class InputDesignTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        protected InputDesignTableModel() {
        }

        @Override
        public int getRowCount() {
            return InputDesignEditorModel.this.factors == null ? 0 : InputDesignEditorModel.this.factors.size();
        }

        @Override
        public int getColumnCount() {
            int result = 0;
            if (InputDesignEditorModel.this.inputDesign != null) {
                result = 1;
                Collection scenarios = InputDesignEditorModel.this.inputDesign.getScenario();
                if (scenarios != null) {
                    result = scenarios.size() + 1;
                }
            }
            return result;
        }

        @Override
        public String getColumnName(int rowIndex) {
            String result = null;
            if (rowIndex == 0) {
                result = I18n._((String)"jmexico.factor.name", (Object[])new Object[0]);
            } else if (InputDesignEditorModel.this.inputDesign != null) {
                Scenario scenario = InputDesignEditorModel.this.inputDesign.getScenario(rowIndex - 1);
                result = scenario == null ? "" : scenario.getName();
            }
            return result;
        }

        @Override
        public Class<?> getColumnClass(int rowIndex) {
            Class<Object> result = Object.class;
            if (rowIndex == 0) {
                result = Factor.class;
            }
            return result;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return InputDesignEditorModel.this.inputDesign != null && columnIndex > 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object result = null;
            if (InputDesignEditorModel.this.inputDesign != null) {
                Scenario scenario;
                Factor factor = InputDesignEditorModel.this.factors.get(rowIndex);
                if (columnIndex == 0) {
                    result = factor;
                } else if ((scenario = InputDesignEditorModel.this.inputDesign.getScenario(--columnIndex)) != null) {
                    Map factorValues = scenario.getFactorValues();
                    result = factorValues.get(factor);
                }
            }
            return result;
        }

        @Override
        public void setValueAt(Object o, int rowIndex, int columnIndex) {
            if (InputDesignEditorModel.this.inputDesign != null && columnIndex > 0) {
                Scenario scenario = InputDesignEditorModel.this.inputDesign.getScenario(columnIndex - 1);
                Factor factor = InputDesignEditorModel.this.factors.get(rowIndex);
                ValueType valueType = factor.getDomain().getValueType();
                String toStringValue = ObjectUtils.toString((Object)o);
                Object value = MexicoUtil.getTypedValue((ValueType)valueType, (String)toStringValue);
                scenario.setFactorValue(factor, value);
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
    }
}

