/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.ObserveDAOHelper;
import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.ObjetFlottant;
import fr.ird.observe.entities.ObjetFlottantImpl;
import fr.ird.observe.entities.referentiel.OperationObjet;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.ui.ObserveTreeModelBuilder;
import fr.ird.observe.ui.UIHelper;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.ObjetFlottantUI;
import java.util.ArrayList;
import java.util.Collection;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.BeanValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.Creator;
import org.nuiton.topia.persistence.util.Deletor;
import org.nuiton.topia.persistence.util.EntityLoador;

public class ObjetFlottantHandler
extends ObserveContentHandler<Activite, ObjetFlottant, ObjetFlottantUI> {
    private static Log log = LogFactory.getLog(ObjetFlottantHandler.class);

    public ObjetFlottantHandler() {
        super(null, new Creator<Activite, ObjetFlottant>(){

            public ObjetFlottant create(Activite parentBean, ObjetFlottant bean) throws TopiaException {
                TopiaContext ctxt = parentBean.getTopiaContext();
                ObjetFlottant beanToSave = (ObjetFlottant)ObserveDAOHelper.getObjetFlottantDAO((TopiaContext)ctxt).create(new Object[0]);
                bean.setTopiaId(beanToSave.getTopiaId());
                parentBean.addObjetFlottant(beanToSave);
                return beanToSave;
            }
        }, new Deletor<Activite, ObjetFlottant>(){

            public void delete(Activite parentBean, ObjetFlottant bean) {
                parentBean.removeObjetFlottant(bean);
            }
        }, EntityLoador.newEntityLoador(ObjetFlottant.class, (TopiaEntity)new ObjetFlottantImpl(), (String[])new String[]{"type", "devenir", "operation", "appartenance", "commentaire", "nomSupply", "nbJourEau"}));
    }

    @Override
    public void openUI(ObjetFlottantUI context) throws Exception {
        super.openUI(context);
        Activite activite = this.getData((JAXXContext)context, Activite.class);
        ObjetFlottant bean = this.getData((JAXXContext)context, ObjetFlottant.class);
        ObserveContentMode mode = this.getObserveContentMode(context);
        if (bean == null) {
            this.getStorageService((JAXXContext)context).preCreate((TopiaEntity)activite, (TopiaEntity)context.getEditBean(), this.loador);
        } else {
            this.loador.load((Object)bean, (Object)context.getEditBean(), true);
        }
        context.setMode(mode);
        if (mode != ObserveContentMode.READ) {
            context.startEdit(bean);
        }
    }

    @Override
    protected ObserveContentMode getObserveContentMode(ObjetFlottantUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == null) {
            boolean create;
            Activite activite = this.getData((JAXXContext)context, Activite.class);
            ObjetFlottant bean = this.getData((JAXXContext)context, ObjetFlottant.class);
            boolean bl = create = bean == null;
            if (create) {
                mode = ObserveContentMode.CREATE;
                context.removeContextValue(ObjetFlottant.class);
            } else {
                mode = activite.isOpen() ? ObserveContentMode.UPDATE : ObserveContentMode.READ;
            }
            if (!create && !activite.isOpen()) {
                this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Activite.class), I18n._((String)"observe.message.activite.not.open"));
            }
        }
        return mode;
    }

    @Override
    public void saveUI(ObjetFlottantUI context, boolean refresh) {
        Activite activite = this.getData((JAXXContext)context, Activite.class);
        ObjetFlottantImpl bean = context.getEditBean();
        boolean create = bean.getTopiaId() == null;
        try {
            if (create) {
                this.getStorageService((JAXXContext)context).create((TopiaEntity)activite, (TopiaEntity)bean, this.loador, this.creator);
            } else {
                ObjetFlottant beanToSave = this.getData((JAXXContext)context, ObjetFlottant.class);
                this.getStorageService((JAXXContext)context).update((TopiaEntity)beanToSave, (TopiaEntity)bean, this.loador);
            }
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
        }
        BeanValidatorUtil.setValidatorChanged((JAXXObject)context, (boolean)false, (String[])new String[0]);
        NavigationTreeNode node = this.getSelectedNode(context);
        if (create) {
            context.setMode(ObserveContentMode.UPDATE);
            ObserveTreeModelBuilder treeBuilder = this.getTreeBuilder((JAXXContext)context);
            NavigationTreeNode parentNode = treeBuilder.removeChildNode(node);
            node = treeBuilder.addObjetFlottant(parentNode, (ObjetFlottant)bean);
            this.stopEditUI(context);
            if (refresh) {
                this.selectNode((JAXXContext)context, node);
            }
        } else {
            this.repaintNode((JAXXContext)context, node);
        }
    }

    @Override
    public void startEditUI(ObjetFlottantUI context, ObjetFlottant o, ObjetFlottant editBean, String ... binding) {
        boolean create = context.getMode() == ObserveContentMode.CREATE;
        context.getValidator().setContextName(create ? "n1-create" : "n1-update");
        if (create) {
            this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(ObjetFlottant.class), I18n._((String)"observe.message.creating.objetFlottant"));
        } else {
            this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(ObjetFlottant.class), I18n._((String)"observe.message.updating.objetFlottant"));
        }
        super.startEditUI(context, o, editBean, "nbJourEau.text", "type.selectedItem", "devenir.selectedItem", "nomSupply.text", "commentaire.text");
        if (create) {
            context.setModified(true);
        }
    }

    @Override
    public void deleteUI(ObjetFlottantUI context) {
        boolean create;
        Activite activite = this.getData((JAXXContext)context, Activite.class);
        ObjetFlottantImpl bean = context.getEditBean();
        if (!UIHelper.confirmForEntityDelete(context, ObjetFlottant.class, bean)) {
            return;
        }
        boolean bl = create = bean.getTopiaId() == null;
        if (!create) {
            try {
                this.getStorageService((JAXXContext)context).delete((TopiaEntity)activite, (TopiaEntity)bean, this.deletator);
            }
            catch (StorageServiceException ex) {
                ErrorDialogUI.showError((Exception)((Object)ex));
            }
        }
        context.stopEdit();
        NavigationTreeNode node = this.getSelectedNode(context);
        NavigationTreeNode parentNode = this.getTreeBuilder((JAXXContext)context).removeChildNode(node);
        this.selectNode((JAXXContext)context, parentNode);
    }

    public void selectOperations(ObjetFlottantUI context, ObjetFlottant bean, Object[] selected) {
        boolean update;
        boolean bl = update = selected.length != bean.sizeOperation();
        if (!update && selected.length > 0) {
            Collection list = bean.getOperation();
            for (Object o : selected) {
                if (list.contains((OperationObjet)o)) continue;
                update = true;
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(selected.length + " do update ? " + update));
        }
        if (update) {
            context.getOperation().getSelectionModel().setValueIsAdjusting(true);
            ArrayList<OperationObjet> newList = new ArrayList<OperationObjet>(selected.length);
            for (Object o : selected) {
                newList.add((OperationObjet)o);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("update operations " + newList.size()));
            }
            bean.setOperation(newList);
            context.getOperation().getSelectionModel().setValueIsAdjusting(false);
        }
    }
}

