/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.ui.content.data;

import fr.ird.observe.entities.Activite;
import fr.ird.observe.entities.Openable;
import fr.ird.observe.entities.Route;
import fr.ird.observe.entities.RouteImpl;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.ui.content.ObserveContentHandler;
import fr.ird.observe.ui.content.ObserveContentMode;
import fr.ird.observe.ui.content.data.ActivitesUI;
import java.util.ArrayList;
import java.util.List;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.validator.BeanValidatorScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.EntityLoador;

public class ActivitesHandler
extends ObserveContentHandler<Void, Route, ActivitesUI>
implements JAXXAction {
    private static Log log = LogFactory.getLog(ActivitesHandler.class);
    EntityLoador<Activite> closeLoador = EntityLoador.newEntityLoador(Activite.class, (String[])new String[]{"quadrant", "latitude", "longitude", "heureObservation", "temperatureSurface", "causeNonCoupSenne", "commentaire", "vitesseBateau", "systemeObserve", "activiteBateau", "activiteEnvironnante", "ventBeaufort", "modeDetection", "calee", "objetFlottant", "open"});

    public ActivitesHandler() {
        super(null, null, null, new EntityLoador<Route>(Route.class, null, new String[]{"open", "activite"}){
            private static final long serialVersionUID = 1L;

            public void load(Route from, Route dst, boolean tech) {
                super.load((TopiaEntity)from, (TopiaEntity)dst, tech);
                List activites = dst.getActivite();
                if (activites != null) {
                    dst.setActivite(new ArrayList(activites));
                }
            }
        });
    }

    public void addActivite(ActivitesUI context) {
        NavigationTreeNode parentNode = this.getSelectedNode(context);
        NavigationTreeNode node = this.getTreeBuilder((JAXXContext)context).addActivite(parentNode, null);
        this.repaintNode((JAXXContext)context, parentNode, true);
        this.selectNode((JAXXContext)context, node);
    }

    public void gotoActivite(ActivitesUI context, Activite selectedActivite) {
        if (selectedActivite == null) {
            return;
        }
        NavigationTreeNode parentNode = this.getSelectedNode(context);
        NavigationTreeNode node = parentNode.getChild(selectedActivite.getTopiaId());
        this.selectNode((JAXXContext)context, node);
    }

    @Override
    public void closeOpenable(ActivitesUI ui) {
        RouteImpl bean = ui.getEditBean();
        Route beanToSave = this.getData((JAXXContext)ui, Route.class);
        Activite activite = bean.getOpenActivite();
        Activite activiteToSave = beanToSave.getOpenActivite();
        activite.setOpen(false);
        try {
            activite = (Activite)this.getStorageService((JAXXContext)ui).update((TopiaEntity)activiteToSave, (TopiaEntity)activite, this.closeLoador);
        }
        catch (StorageServiceException ex) {
            ErrorDialogUI.showError((Exception)((Object)ex));
            return;
        }
        this.closeOpenable(ui, (Openable)activite, I18n._((String)"observe.message.no.active.activite.found"));
        ui.setMode(ObserveContentMode.CREATE);
    }

    @Override
    public void openUI(ActivitesUI context) throws Exception {
        super.openUI(context);
        Route route = this.getData((JAXXContext)context, Route.class);
        ObserveContentMode mode = this.getObserveContentMode(context);
        this.loador.load((Object)route, (Object)context.getEditBean(), true);
        context.setMode(mode);
    }

    @Override
    protected ObserveContentMode getObserveContentMode(ActivitesUI context) {
        ObserveContentMode mode = super.getObserveContentMode(context);
        if (mode == null) {
            Route route = this.getData((JAXXContext)context, Route.class);
            Activite openActivite = this.getDataContext((JAXXContext)context).getOpenActivite();
            if (openActivite == null) {
                if (route.isOpen()) {
                    mode = ObserveContentMode.CREATE;
                    this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.no.active.activite.found"));
                } else {
                    mode = ObserveContentMode.READ;
                }
            } else if (route.getOpenChild() != null) {
                mode = ObserveContentMode.UPDATE;
                this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.active.activite.found"));
            } else {
                mode = ObserveContentMode.READ;
                this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.active.activite.found.for.other.route"));
            }
            if (!route.isOpen()) {
                this.addMessage(context, BeanValidatorScope.INFO, this.getEntityLabel(Route.class), I18n._((String)"observe.message.route.not.open"));
            }
        }
        return mode;
    }
}

