/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.ObserveAction;
import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.ObserveDataContext;
import fr.ird.observe.ObserveDecoratorProvider;
import fr.ird.observe.storage.DbMode;
import fr.ird.observe.storage.StorageService;
import fr.ird.observe.storage.StorageServiceFactory;
import fr.ird.observe.storage.impl.H2StorageService;
import fr.ird.observe.ui.ObserveMainUI;
import fr.ird.observe.ui.ObserveMainUIHandler;
import fr.ird.observe.ui.UIHelper;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.Util;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.jdbc.JdbcSQLException;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ConverterUtil;
import org.nuiton.util.StringUtil;

public class ObserveMain {
    private static Log log = LogFactory.getLog(ObserveMain.class);

    public static void main(String[] args) {
        long startingTime = System.nanoTime();
        log.info((Object)("Observe start at " + new Date() + " args: " + Arrays.toString(args)));
        try {
            ObserveContext context = ObserveMain.init(true, args);
            log.info((Object)I18n._((String)"observe.init.context.done", (Object[])new Object[]{StringUtil.convertTime((long)startingTime, (long)System.nanoTime())}));
            Util.checkJAXXContextEntry((JAXXContext)context, (JAXXContextEntryDef)Util.newContextEntryDef(ObserveConfig.class));
            Util.checkJAXXContextEntry((JAXXContext)context, (JAXXContextEntryDef)Util.newContextEntryDef(ObserveAction.class));
            Util.checkJAXXContextEntry((JAXXContext)context, (JAXXContextEntryDef)Util.newContextEntryDef(ObserveDataContext.class));
            ObserveConfig config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
            config.doAction(ObserveConfig.Step.AfterInit.ordinal());
            if (config.isDisplayMainUI()) {
                ObserveMainUIHandler uiHandler = (ObserveMainUIHandler)context.getContextValue(ObserveMainUIHandler.class);
                final ObserveMainUI ui = uiHandler.initUI(context, config);
                log.info((Object)I18n._((String)"observe.init.ui.done"));
                if (config.isLocalStorageExist()) {
                    H2StorageService service = context.newLocalStorageService();
                    context.prepareMainStorage((StorageService<?>)service);
                    log.info((Object)I18n._((String)"observe.init.local.db.detected", (Object[])new Object[]{service.getLabel()}));
                    try {
                        service.doOpen();
                    }
                    catch (Exception eee) {
                        JdbcSQLException error;
                        Throwable cause;
                        for (cause = eee.getCause(); cause != null && cause.getCause() != null; cause = cause.getCause()) {
                        }
                        if (cause != null && cause instanceof JdbcSQLException && (error = (JdbcSQLException)cause).getMessage().contains("Locked")) {
                            JOptionPane.showMessageDialog(null, I18n._((String)"observe.error.open.first.db"), I18n._((String)"observe.title.error.dialog"), 0);
                            System.exit(1);
                            return;
                        }
                        throw eee;
                    }
                } else {
                    int reponse = UIHelper.askUser(I18n._((String)"observe.title.no.local.db.found"), I18n._((String)"observe.message.no.local.db.found", (Object[])new Object[]{config.getLocalDBDirectory()}), 3, new Object[]{I18n._((String)"observe.choice.useRemoteStorage"), I18n._((String)"observe.choice.createLocalStorage"), I18n._((String)"observe.choice.doNothing")}, 1);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("response : " + reponse));
                    }
                    DbMode dbMode = null;
                    String title = null;
                    if (reponse != -1 && reponse < 2) {
                        if (reponse == 1) {
                            dbMode = DbMode.LOCAL;
                            title = I18n.n_((String)"observe.title.create.local.db");
                        } else {
                            dbMode = DbMode.REMOTE;
                            title = I18n.n_((String)"observe.title.load.remote.db");
                        }
                    }
                    if (dbMode != null) {
                        uiHandler.launchChangeStorage((JAXXContext)context, dbMode, title);
                    }
                }
                log.info((Object)I18n._((String)"observe.init.storage.done"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ui.setVisible(true);
                    }
                });
            }
        }
        catch (Exception e) {
            ErrorDialogUI.showError((Exception)e);
            log.error((Object)e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public static ObserveContext init(boolean initLocalSotrage, String ... args) throws Exception {
        System.setSecurityManager(null);
        long t0 = System.nanoTime();
        I18n.setUniqueBundleName((String)"observe-swing-i18n");
        Runtime.getRuntime().addShutdownHook(new ShutdownHook());
        ObserveContext context = ObserveContext.init();
        ObserveConfig config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        config.parse(args);
        long t00 = System.nanoTime();
        I18n.init((Locale)config.getLocale());
        log.info((Object)("language : " + config.getLocale()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("i18n loading time : " + StringUtil.convertTime((long)t00, (long)System.nanoTime())));
        }
        context.setContextValue(new ObserveDecoratorProvider());
        context.getContextValue(ObserveDataContext.class);
        log.info((Object)I18n._((String)"observe.message.config.loaded", (Object[])new Object[]{config.getVersion()}));
        try {
            SwingUtil.initNimbusLoookAndFeel();
        }
        catch (Exception e) {
            log.warn((Object)I18n._((String)"observe.warning.nimbus.landf"));
        }
        catch (Throwable e) {
            log.warn((Object)I18n._((String)"observe.warning.no.ui"));
            config.setCanUseUI(false);
        }
        Converter converter = ConverterUtil.getConverter(Date.class);
        if (converter != null) {
            ConvertUtils.deregister(Date.class);
            DateConverter dateConverter = new DateConverter();
            dateConverter.setUseLocaleFormat(true);
            ConvertUtils.register((Converter)dateConverter, Date.class);
        }
        if (config.isCanUseUI()) {
            SwingUtil.loadUIConfig((String)"/observe.properties", null);
        }
        if (initLocalSotrage) {
            boolean hasLocalStorage = context.isLocalStorageExists();
            config.setLocalStorageExist(hasLocalStorage);
            if (!hasLocalStorage) {
                log.info((Object)I18n._((String)"observe.init.no.local.db.detected", (Object[])new Object[]{config.getLocalDBDirectory()}));
            }
            boolean hasInitialDb = context.isInitialDbExists();
            config.setInitialDumpExist(hasInitialDb);
            if (!hasInitialDb) {
                log.info((Object)I18n._((String)"observe.init.no.initial.dump.detected", (Object[])new Object[]{config.getInitialDbDump()}));
            }
        }
        StorageServiceFactory.setApplicationContext((DefaultApplicationContext)context);
        if (log.isDebugEnabled()) {
            log.debug((Object)("init done in " + StringUtil.convertTime((long)t0, (long)System.nanoTime())));
        }
        return context;
    }

    public static class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("shutdown observe");
        }

        @Override
        public void run() {
            try {
                super.run();
                ObserveContext.get().close();
                log.info((Object)I18n._((String)"observe.init.closed", (Object[])new Object[]{new Date()}));
                Runtime.getRuntime().halt(0);
            }
            catch (Exception ex) {
                log.error((Object)("error while closing " + ex.getMessage()), (Throwable)ex);
                Runtime.getRuntime().halt(1);
            }
        }
    }
}

