/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe;

import fr.ird.observe.ObserveConfig;
import fr.ird.observe.ObserveContext;
import fr.ird.observe.storage.CommonStorageConfigParam;
import fr.ird.observe.storage.DbMode;
import fr.ird.observe.storage.StorageServiceException;
import fr.ird.observe.storage.StorageServiceFactory;
import fr.ird.observe.storage.impl.PGStorageConfig;
import fr.ird.observe.storage.impl.PGStorageConfigParam;
import fr.ird.observe.storage.impl.PGStorageService;
import fr.ird.observe.ui.ObserveMainUIHandler;
import java.awt.Component;
import java.awt.Frame;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import javax.help.JHelp;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.DefaultApplicationContext;
import jaxx.runtime.swing.ErrorDialogUI;
import jaxx.runtime.swing.help.JAXXHelpBroker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;

@DefaultApplicationContext.AutoLoad
public class ObserveAction {
    private static Log log = LogFactory.getLog(ObserveAction.class);
    protected ObserveConfig config;

    public ObserveAction() {
    }

    public ObserveAction(ObserveConfig config) {
        this.config = config;
    }

    public void configure() {
        this.disableMainUI();
        ObserveContext context = ObserveContext.get();
        ObserveMainUIHandler handler = (ObserveMainUIHandler)context.getContextValue(ObserveMainUIHandler.class);
        handler.showConfig((JAXXContext)context);
    }

    public void help() {
        this.disableMainUI();
        System.out.println(I18n._((String)"observe.message.help.usage", (Object[])new Object[]{this.getConfig().getVersion()}));
        System.out.println("Options (set with --option <key> <value>:");
        for (ObserveConfig.Option option : ObserveConfig.Option.values()) {
            System.out.println("\t" + option.key + "(" + option.defaultValue + "):" + I18n._((String)option.description));
        }
        System.out.println("Actions:");
        for (Enum enum_ : ObserveConfig.Action.values()) {
            System.out.println("\t" + Arrays.toString(((ObserveConfig.Action)enum_).aliases) + "(" + ((ObserveConfig.Action)enum_).action + "):" + I18n._((String)((ObserveConfig.Action)enum_).description));
        }
        System.exit(0);
    }

    public void helpUI() {
        JAXXHelpBroker helpBroker = new JAXXHelpBroker(this.getConfig().getLocale(), "observe", "help", "top", null);
        log.debug((Object)"no mainUI, open in autonome frame");
        JHelp ui = new JHelp(helpBroker.getHelpset());
        JDialog frame = new JDialog((Frame)null, true);
        frame.setTitle(I18n._((String)"observe.help.top.title"));
        frame.setSize(1024, 800);
        frame.add((Component)ui);
        frame.setVisible(true);
        this.disableMainUI();
        System.exit(0);
    }

    public void disableMainUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.getConfig().setDisplayMainUI(false);
    }

    public void launchSynchroUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.disableMainUI();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ObserveContext context = ObserveContext.get();
                try {
                    ObserveMainUIHandler uiHandler = (ObserveMainUIHandler)context.getContextValue(ObserveMainUIHandler.class);
                    uiHandler.launchExportData((JAXXContext)context);
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    context.releaseLock();
                }
            }
        });
    }

    public void launchValidationUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.disableMainUI();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ObserveContext context = ObserveContext.get();
                try {
                    ObserveMainUIHandler uiHandler = (ObserveMainUIHandler)context.getContextValue(ObserveMainUIHandler.class);
                    uiHandler.launchValidateData((JAXXContext)context);
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    context.releaseLock();
                }
            }
        });
    }

    public void launchStorageUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.disableMainUI();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ObserveContext context = ObserveContext.get();
                try {
                    ObserveMainUIHandler uiHandler = (ObserveMainUIHandler)context.getContextValue(ObserveMainUIHandler.class);
                    uiHandler.launchChangeStorage((JAXXContext)context, null, null);
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    context.releaseLock();
                }
            }
        });
    }

    public void launchUpdatePgWithUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.disableMainUI();
        this.getConfig().setOption("auto.migrate", "false");
        this.getConfig().setCanMigrateObstuna(true);
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ObserveContext context = ObserveContext.get();
                try {
                    ObserveMainUIHandler uiHandler = (ObserveMainUIHandler)context.getContextValue(ObserveMainUIHandler.class);
                    uiHandler.launchChangeStorage((JAXXContext)context, DbMode.REMOTE, I18n.n_((String)"observe.title.update.remote.db"));
                }
                catch (Exception e) {
                    ErrorDialogUI.showError((Exception)e);
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    context.releaseLock();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchUpdatePg(String url, String login, char[] password) throws StorageServiceException, IOException, InterruptedException, SQLException, TopiaNotFoundException, TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.disableMainUI();
        this.getConfig().setOption("auto.migrate", "false");
        PGStorageConfig c2 = StorageServiceFactory.newPGConfig((String)I18n.n_((String)"observe.storage.label.remote"), (Object[])new Object[]{PGStorageConfigParam.URL, url, CommonStorageConfigParam.LOGIN, login, CommonStorageConfigParam.PASSWORD, password, CommonStorageConfigParam.CAN_MIGRATE, true});
        boolean findRemote = c2.canConnect();
        if (!findRemote) {
            throw new IllegalArgumentException(I18n._((String)"observe.error.could.not.connect.to.remote.db", (Object[])new Object[]{url, login}));
        }
        log.info((Object)I18n._((String)"observe.message.connect.to.remote.db", (Object[])new Object[]{url, login}));
        ObserveContext context = ObserveContext.get();
        try {
            PGStorageService remoteService = StorageServiceFactory.newService((PGStorageConfig)c2);
            remoteService.doOpen();
        }
        finally {
            context.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchCreatePg(String url, String login, char[] password) throws StorageServiceException, IOException, InterruptedException, TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.disableMainUI();
        PGStorageConfig c2 = StorageServiceFactory.newPGConfig((String)I18n.n_((String)"observe.storage.label.remote"), (Object[])new Object[]{PGStorageConfigParam.URL, url, CommonStorageConfigParam.LOGIN, login, CommonStorageConfigParam.PASSWORD, password, CommonStorageConfigParam.CAN_MIGRATE, false});
        boolean findRemote = c2.canConnect();
        if (!findRemote) {
            throw new IllegalArgumentException(I18n._((String)"observe.error.could.not.connect.to.remote.db", (Object[])new Object[]{url, login}));
        }
        log.info((Object)I18n._((String)"observe.message.connect.to.remote.db", (Object[])new Object[]{url, login}));
        ObserveContext context = ObserveContext.get();
        try {
            PGStorageService remoteService = StorageServiceFactory.newService((PGStorageConfig)c2);
            remoteService.doOpen();
            remoteService.getCtxt().createSchema();
        }
        finally {
            context.releaseLock();
        }
    }

    protected ObserveConfig getConfig() {
        if (this.config == null) {
            ObserveContext context = ObserveContext.get();
            this.config = (ObserveConfig)((Object)context.getContextValue(ObserveConfig.class));
        }
        return this.config;
    }
}

