/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.rmi.tester;

import fr.inria.peerunit.Bootstrapper;
import fr.inria.peerunit.Coordinator;
import fr.inria.peerunit.GlobalVariables;
import fr.inria.peerunit.Tester;
import fr.inria.peerunit.base.AbstractTester;
import fr.inria.peerunit.base.ResultSet;
import fr.inria.peerunit.parser.MethodDescription;
import fr.inria.peerunit.rmi.coord.CoordinatorImpl;
import fr.inria.peerunit.rmi.tester.TesterImpl;
import fr.inria.peerunit.util.TesterUtil;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedTesterImpl
extends AbstractTester
implements Tester,
Coordinator,
Serializable {
    private static final long serialVersionUID = 2806863880157215029L;
    private static Logger LOG = Logger.getLogger(TesterImpl.class.getName());
    private transient Coordinator parent;
    private transient List<Tester> testers = new LinkedList<Tester>();
    private transient Bootstrapper bootstrapper;
    private transient TesterImpl tester;
    private transient CoordinatorImpl coordinator;
    private transient Class<?> testCaseClass;

    public DistributedTesterImpl(Class<?> klass, Bootstrapper boot, GlobalVariables gv, TesterUtil tu) throws RemoteException {
        super(gv);
        this.defaults = tu;
        this.bootstrapper = boot;
        this.testCaseClass = klass;
    }

    public void register() {
        LOG.entering("DistributedTester", "register()");
        try {
            this.setId(this.bootstrapper.register(this));
            this.initializeLogger();
        }
        catch (RemoteException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void registerTesters(List<Tester> l) throws RemoteException {
        assert (l != null) : "Null argument";
        assert (!l.isEmpty()) : "Empty argument";
        LOG.entering("DistributedTesterImpl", "registerTesters(List<Tester>)", l.size());
        this.testers.addAll(l);
    }

    private void createLocalCoordinator() {
        LOG.entering("DistributedTester", "startCoordination()");
        this.coordinator = new CoordinatorImpl(this.testers.size(), this.defaults.getRelaxIndex());
    }

    @Override
    public void registerMethods(Tester tester, Collection<MethodDescription> list) throws RemoteException {
        assert (this.testers.contains(tester));
        this.coordinator.registerMethods(tester, list);
    }

    @Override
    public void execute(MethodDescription md) throws RemoteException {
        LOG.entering("DistributedTester", "Execute", md);
        try {
            this.coordinator.execute(md);
            ResultSet result = this.coordinator.getResultFor(md);
            this.parent.methodExecutionFinished(result);
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, null, e);
        }
    }

    @Override
    public void methodExecutionFinished(ResultSet result) throws RemoteException {
        assert (this.coordinator != null) : "Null Coordinator";
        this.coordinator.methodExecutionFinished(result);
    }

    @Override
    public void quit(Tester t) throws RemoteException {
        assert (this.coordinator != null) : "Null Coordinator";
        LOG.entering(null, null);
        LOG.fine(String.format("Tester %s is leaving.", t));
        this.coordinator.quit(t);
    }

    @Override
    public void kill() throws RemoteException {
        for (Tester each : this.testers) {
            each.kill();
        }
    }

    @Override
    public void setCoordinator(Coordinator coord) {
        LOG.entering("DistributedTesterImpl", "setCoordinator(Coordinator)");
        this.parent = coord;
    }

    @Override
    public void start() throws RemoteException {
        LOG.entering("DistributedTester", "start()");
        Thread root = new Thread(new DistributedTesterThread());
        root.start();
        LOG.exiting("DistributedTester", "start()");
    }

    private void createLocalTester() {
        this.tester = new TesterImpl(this.globalTable(), this.getId(), this.defaults);
        this.tester.registerTestCase(this.testCaseClass);
        this.testers.add(this.tester);
    }

    private void registerWithParent() throws RemoteException {
        assert (this.parent != null) : "Trying to register with a null parent";
        Collection<MethodDescription> methods = this.coordinator.getSchedule().methods();
        this.parent.registerMethods(this, methods);
    }

    private void cleanUp() {
        LOG.fine(String.format("DistributedTester %d cleaning up.", this.id));
        try {
            this.testers.clear();
            this.tester.cleanUp();
            this.tester = null;
            this.coordinator.cleanUp();
            this.coordinator = null;
            this.bootstrapper = null;
            this.globals = null;
            this.parent = null;
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NoSuchObjectException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    class DistributedTesterThread
    implements Runnable {
        DistributedTesterThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOG.fine(String.format("Starting Tester %d", DistributedTesterImpl.this.id));
            DistributedTesterImpl.this.createLocalTester();
            DistributedTesterImpl.this.createLocalCoordinator();
            try {
                for (Tester each : DistributedTesterImpl.this.testers) {
                    each.setCoordinator(DistributedTesterImpl.this);
                }
                for (Tester each : DistributedTesterImpl.this.testers) {
                    each.start();
                }
                Thread tt = new Thread((Runnable)DistributedTesterImpl.this.tester, "LocalTester for DT: " + DistributedTesterImpl.this.id);
                tt.start();
                DistributedTesterImpl.this.coordinator.waitForTesterRegistration();
                LOG.fine("Registration finished");
                if (DistributedTesterImpl.this.parent == null) {
                    LOG.fine(String.format("I am root (DistributedTester %d)", DistributedTesterImpl.this.id));
                    LOG.fine("ROOT: will start the execution.");
                    DistributedTesterImpl.this.coordinator.testcaseExecution();
                    LOG.fine("ROOT: execution finished, waiting for testers to quit.");
                    DistributedTesterImpl.this.coordinator.waitAllTestersToQuit();
                    LOG.fine("ROOT: all testers quit, calculating verdict.");
                    DistributedTesterImpl.this.coordinator.printVerdict();
                    DistributedTesterImpl.this.bootstrapper.quit();
                } else {
                    LOG.fine(String.format("DistributedTester %d will register with parent", DistributedTesterImpl.this.id));
                    DistributedTesterImpl.this.registerWithParent();
                    DistributedTesterImpl.this.coordinator.waitAllTestersToQuit();
                    LOG.fine(String.format("DistributedTester %d will now quit", DistributedTesterImpl.this.id));
                    DistributedTesterImpl.this.parent.quit(DistributedTesterImpl.this);
                }
                LOG.fine("Waiting for tester thread");
                tt.join();
                LOG.fine("Tester thread finished");
                DistributedTesterImpl.this.cleanUp();
                System.exit(0);
            }
            catch (RemoteException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            finally {
                System.exit(1);
            }
        }
    }
}

