/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.base;

import fr.inria.peerunit.base.ResultSet;
import fr.inria.peerunit.parser.MethodDescription;
import fr.inria.peerunit.test.oracle.Verdicts;
import java.io.Serializable;

public class SingleResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private MethodDescription md;
    private int testerId;
    private long start;
    private long stop;
    private Verdicts verdict = Verdicts.PASS;

    public SingleResult(int id, MethodDescription md) {
        this.testerId = id;
        this.md = md;
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public void stop() {
        this.stop = System.currentTimeMillis();
    }

    public void addError(Throwable t) {
        this.verdict = Verdicts.ERROR;
    }

    public void addFailure(AssertionError ae) {
        this.verdict = Verdicts.FAIL;
    }

    public void addInconclusive(Throwable t) {
        this.verdict = Verdicts.INCONCLUSIVE;
    }

    public long getDelay() {
        return this.stop - this.start;
    }

    public MethodDescription getMethodDescription() {
        return this.md;
    }

    public int getTesterId() {
        return this.testerId;
    }

    public Verdicts getVerdict() {
        return this.verdict;
    }

    public ResultSet asResultSet() {
        ResultSet rs = new ResultSet(this.md);
        rs.add(this);
        return rs;
    }
}

