/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit.base;

import fr.inria.peerunit.GlobalVariables;
import fr.inria.peerunit.parser.AfterClass;
import fr.inria.peerunit.parser.AfterClassMethod;
import fr.inria.peerunit.parser.BeforeClass;
import fr.inria.peerunit.parser.BeforeClassMethod;
import fr.inria.peerunit.parser.SetGlobals;
import fr.inria.peerunit.parser.SetId;
import fr.inria.peerunit.parser.TestStep;
import fr.inria.peerunit.parser.TestStepMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassFilter {
    private List<TestStepMethod> stepMethods = new ArrayList<TestStepMethod>();
    private List<BeforeClassMethod> beforeMethods = new ArrayList<BeforeClassMethod>();
    private List<AfterClassMethod> afterMethods = new ArrayList<AfterClassMethod>();
    private Method setId;
    private Method setGlobals;

    public ClassFilter(Class<?> c) {
        Method[] methods;
        for (Method each : methods = c.getMethods()) {
            if (each.isAnnotationPresent(TestStep.class)) {
                this.stepMethods.add(new TestStepMethod(each));
                continue;
            }
            if (each.isAnnotationPresent(BeforeClass.class)) {
                this.beforeMethods.add(new BeforeClassMethod(each));
                continue;
            }
            if (each.isAnnotationPresent(AfterClass.class)) {
                this.afterMethods.add(new AfterClassMethod(each));
                continue;
            }
            if (each.isAnnotationPresent(SetId.class) && each.getParameterTypes().length == 1 && each.getParameterTypes()[0] == Integer.TYPE) {
                this.setId = each;
                continue;
            }
            if (!each.isAnnotationPresent(SetGlobals.class) || each.getParameterTypes().length != 1 || each.getParameterTypes()[0] != GlobalVariables.class) continue;
            this.setGlobals = each;
        }
    }

    public List<TestStepMethod> stepMethods() {
        return this.stepMethods;
    }

    public List<BeforeClassMethod> beforeMethods() {
        return this.beforeMethods;
    }

    public List<AfterClassMethod> afterMethods() {
        return this.afterMethods;
    }

    public Method setId() {
        return this.setId;
    }

    public Method setGlobals() {
        return this.setGlobals;
    }
}

