/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.peerunit;

import fr.inria.peerunit.Bootstrapper;
import fr.inria.peerunit.Coordinator;
import fr.inria.peerunit.GlobalVariables;
import fr.inria.peerunit.GlobalVariablesImpl;
import fr.inria.peerunit.btree.BootstrapperImpl;
import fr.inria.peerunit.rmi.coord.CoordinatorImpl;
import fr.inria.peerunit.util.LogFormat;
import fr.inria.peerunit.util.TesterUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CoordinatorRunner {
    private static final Logger LOG = Logger.getLogger(CoordinatorRunner.class.getName());
    private static final GlobalVariablesImpl globals = new GlobalVariablesImpl();
    private TesterUtil defaults;
    private static Registry registry;

    public CoordinatorRunner(TesterUtil tu) {
        this.defaults = tu;
        try {
            this.initializeRegistry();
            this.initializeLogger();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    private void initializeLogger() throws IOException {
        Level l = this.defaults.getLogLevel();
        FileHandler handler = new FileHandler("coordination.log");
        handler.setFormatter(new LogFormat());
        handler.setLevel(l);
        Logger myLogger = Logger.getLogger("fr.inria");
        myLogger.setUseParentHandlers(false);
        myLogger.addHandler(handler);
        myLogger.setLevel(l);
    }

    private void initializeRegistry() throws RemoteException {
        try {
            registry = LocateRegistry.createRegistry(this.defaults.getRegistryPort());
        }
        catch (RemoteException e) {
            registry = LocateRegistry.getRegistry(this.defaults.getRegistryPort());
        }
        assert (registry != null);
    }

    private void start() throws RemoteException, AlreadyBoundException, InterruptedException, NotBoundException {
        LOG.entering("CoordinatorRunner", "start()");
        this.bindGlobals();
        if (this.defaults.getCoordinationType() == 0) {
            this.startCoordinator();
        } else {
            this.startBootstrapper();
        }
        this.cleanAndUnbind();
        System.exit(0);
    }

    public void startCoordinator() throws RemoteException, AlreadyBoundException, InterruptedException {
        LOG.info("Using the centralized architecture");
        CoordinatorImpl cii = new CoordinatorImpl(this.defaults);
        Coordinator stub = (Coordinator)UnicastRemoteObject.exportObject((Remote)cii, 0);
        LOG.info("New Coordinator address is : " + this.defaults.getServerAddr());
        registry.bind("Coordinator", stub);
        Thread coordination = new Thread((Runnable)cii, "Coordinator");
        coordination.start();
        coordination.join();
        LOG.info("Coordination thread finished");
    }

    public void startBootstrapper() throws RemoteException, AlreadyBoundException, InterruptedException {
        LOG.info("Using the distributed architecture");
        BootstrapperImpl bootstrapper = new BootstrapperImpl(this.defaults);
        Bootstrapper bootStub = (Bootstrapper)UnicastRemoteObject.exportObject((Remote)bootstrapper, 0);
        registry.bind("Bootstrapper", bootStub);
        Thread boot = new Thread((Runnable)bootstrapper, "Bootstrapper");
        boot.start();
        boot.join();
        LOG.info("Bootstrap thread finished");
    }

    public void bindGlobals() throws RemoteException, AlreadyBoundException {
        assert (registry != null);
        GlobalVariables globalsStub = (GlobalVariables)((Object)UnicastRemoteObject.exportObject(globals));
        registry.bind("Globals", globalsStub);
    }

    public void cleanAndUnbind() throws RemoteException {
        try {
            registry.unbind("Bootstrapper");
            registry.unbind("Coordinator");
            registry.unbind("Globals");
        }
        catch (NotBoundException notBoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            TesterUtil defaults;
            FileInputStream fs;
            if (args.length == 1) {
                String filename = args[0];
                fs = new FileInputStream(filename);
                defaults = new TesterUtil(fs);
            } else if (new File("peerunit.properties").exists()) {
                String filename = "peerunit.properties";
                fs = new FileInputStream(filename);
                defaults = new TesterUtil(fs);
            } else {
                defaults = TesterUtil.instance;
            }
            CoordinatorRunner cr = new CoordinatorRunner(defaults);
            cr.start();
        }
        catch (RemoteException ex) {
            LOG.log(Level.SEVERE, null, ex);
            ex.printStackTrace();
        }
        catch (AlreadyBoundException ex) {
            LOG.log(Level.SEVERE, null, ex);
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            LOG.log(Level.SEVERE, null, ex);
            ex.printStackTrace();
        }
        catch (NotBoundException ex) {
            LOG.log(Level.SEVERE, null, ex);
            ex.printStackTrace();
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: Unable to open properties file");
        }
        finally {
            System.exit(1);
        }
    }
}

