/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest.tst;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.solr.spelling.suggest.tst.TernaryTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TSTAutocomplete {
    public void balancedTree(Object[] tokens, Object[] vals, int lo, int hi, TernaryTreeNode root) {
        if (lo > hi) {
            return;
        }
        int mid = (lo + hi) / 2;
        root = this.insert(root, (String)tokens[mid], vals[mid], 0);
        this.balancedTree(tokens, vals, lo, mid - 1, root);
        this.balancedTree(tokens, vals, mid + 1, hi, root);
    }

    /*
     * Enabled aggressive block sorting
     */
    public TernaryTreeNode insert(TernaryTreeNode currentNode, String s, Object val, int x) {
        if (s == null) return currentNode;
        if (s.length() <= x) {
            return currentNode;
        }
        if (currentNode == null) {
            TernaryTreeNode newNode = new TernaryTreeNode();
            newNode.splitchar = s.charAt(x);
            currentNode = newNode;
            if (x < s.length() - 1) {
                currentNode.eqKid = this.insert(currentNode.eqKid, s, val, x + 1);
                return currentNode;
            }
            currentNode.token = s;
            currentNode.val = val;
            return currentNode;
        }
        if (currentNode.splitchar > s.charAt(x)) {
            currentNode.loKid = this.insert(currentNode.loKid, s, val, x);
            return currentNode;
        }
        if (currentNode.splitchar != s.charAt(x)) {
            currentNode.hiKid = this.insert(currentNode.hiKid, s, val, x);
            return currentNode;
        }
        if (x < s.length() - 1) {
            currentNode.eqKid = this.insert(currentNode.eqKid, s, val, x + 1);
            return currentNode;
        }
        currentNode.token = s;
        currentNode.val = val;
        return currentNode;
    }

    public ArrayList<TernaryTreeNode> prefixCompletion(TernaryTreeNode root, String s, int x) {
        TernaryTreeNode p = root;
        ArrayList<TernaryTreeNode> suggest = new ArrayList<TernaryTreeNode>();
        while (p != null) {
            if (s.charAt(x) < p.splitchar) {
                p = p.loKid;
                continue;
            }
            if (s.charAt(x) == p.splitchar) {
                if (x == s.length() - 1) break;
                ++x;
                p = p.eqKid;
                continue;
            }
            p = p.hiKid;
        }
        if (p == null) {
            return suggest;
        }
        if (p.eqKid == null && p.token == null) {
            return suggest;
        }
        if (p.eqKid == null && p.token != null) {
            suggest.add(p);
            return suggest;
        }
        if (p.token != null) {
            suggest.add(p);
        }
        p = p.eqKid;
        Stack<TernaryTreeNode> st = new Stack<TernaryTreeNode>();
        st.push(p);
        while (!st.empty()) {
            TernaryTreeNode top = (TernaryTreeNode)st.peek();
            st.pop();
            if (top.token != null) {
                suggest.add(top);
            }
            if (top.eqKid != null) {
                st.push(top.eqKid);
            }
            if (top.loKid != null) {
                st.push(top.loKid);
            }
            if (top.hiKid == null) continue;
            st.push(top.hiKid);
        }
        return suggest;
    }
}

