/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyField;


public  class AgentSkillDTO implements AgentSkill {


@WikittyField(fqn="AgentSkill.comment")    protected String comment;

@WikittyField(fqn="AgentSkill.nature")    protected String nature;

@WikittyField(fqn="AgentSkill.technicalSkill")    protected String technicalSkill;

@WikittyField(fqn="AgentSkill.domainSkill")    protected String domainSkill;

@WikittyField(fqn="AgentSkill.frequency")    protected String frequency;

@WikittyField(fqn="AgentSkill.agent")    protected String agent;
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;
    /**
     * getComment :
     * @return String 
     */

    @Override
    public String getComment() {
        return comment;
}

    /**
     * setComment :
     * @param comment 
     */

    @Override
    public void setComment(String comment) {
        this.comment=comment;
        modificationCount++;
}

    /**
     * getNature :
     * @return String 
     */

    @Override
    public String getNature() {
        return nature;
}

    /**
     * setNature :
     * @param nature 
     */

    @Override
    public void setNature(String nature) {
        this.nature=nature;
        modificationCount++;
}

    /**
     * getTechnicalSkill :
     * @return String 
     */

    @Override
    public String getTechnicalSkill() {
        return technicalSkill;
}

    /**
     * setTechnicalSkill :
     * @param technicalSkill 
     */

    @Override
    public void setTechnicalSkill(String technicalSkill) {
        this.technicalSkill=technicalSkill;
        modificationCount++;
}

    /**
     * getDomainSkill :
     * @return String 
     */

    @Override
    public String getDomainSkill() {
        return domainSkill;
}

    /**
     * setDomainSkill :
     * @param domainSkill 
     */

    @Override
    public void setDomainSkill(String domainSkill) {
        this.domainSkill=domainSkill;
        modificationCount++;
}

    /**
     * getFrequency :
     * @return String 
     */

    @Override
    public String getFrequency() {
        return frequency;
}

    /**
     * setFrequency :
     * @param frequency 
     */

    @Override
    public void setFrequency(String frequency) {
        this.frequency=frequency;
        modificationCount++;
}

    /**
     * getAgent :
     * @return String 
     */

    @Override
    public String getAgent() {
        return agent;
}

    /**
     * setAgent :
     * @param agent 
     */

    @Override
    public void setAgent(String agent) {
        this.agent=agent;
        modificationCount++;
}

    /**
     * AgentSkillDTO :
     */

    public AgentSkillDTO() {
}

    /**
     * AgentSkillDTO :
     * @param wikittyId 
     */

    public AgentSkillDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    /**
     * getWikittyId :
     * @return String 
     */

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    /**
     * setWikittyId :
     * @param wikittyId 
     */

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * getWikittyVersion :
     * @return String 
     */

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    /**
     * setWikittyVersion :
     * @param wikittyVersion 
     */

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * addPropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionFields :
     * @param ext 
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionNames :
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getField :
     * @param ext 
     * @param fieldName 
     * @return Object 
     */

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * setField :
     * @param ext 
     * @param fieldName 
     * @param value 
     */

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * copyFrom :
     * @param source 
     */

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof AgentSkill)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        AgentSkill sourceCopy = (AgentSkill)source;

        setComment(sourceCopy.getComment());

        setNature(sourceCopy.getNature());

        setTechnicalSkill(sourceCopy.getTechnicalSkill());

        setDomainSkill(sourceCopy.getDomainSkill());

        setFrequency(sourceCopy.getFrequency());

        setAgent(sourceCopy.getAgent());

        setWikittyVersion(sourceCopy.getWikittyVersion());
}


} //AgentSkillDTO
