/*
 * #%L
 * Refcomp :: entities
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyField;


public  class UserDTO implements User {


@WikittyField(fqn="User.lastName")    protected String lastName;

@WikittyField(fqn="User.firstName")    protected String firstName;

@WikittyField(fqn="User.email")    protected String email;

@WikittyField(fqn="User.comment")    protected String comment;

@WikittyField(fqn="WikittyUser.login")    protected String login;

@WikittyField(fqn="WikittyUser.password")    protected String password;
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;
    /**
     * getLastName :
     * @return String 
     */

    @Override
    public String getLastName() {
        return lastName;
}

    /**
     * setLastName :
     * @param lastName 
     */

    @Override
    public void setLastName(String lastName) {
        this.lastName=lastName;
        modificationCount++;
}

    /**
     * getFirstName :
     * @return String 
     */

    @Override
    public String getFirstName() {
        return firstName;
}

    /**
     * setFirstName :
     * @param firstName 
     */

    @Override
    public void setFirstName(String firstName) {
        this.firstName=firstName;
        modificationCount++;
}

    /**
     * getEmail :
     * @return String 
     */

    @Override
    public String getEmail() {
        return email;
}

    /**
     * setEmail :
     * @param email 
     */

    @Override
    public void setEmail(String email) {
        this.email=email;
        modificationCount++;
}

    /**
     * getComment :
     * @return String 
     */

    @Override
    public String getComment() {
        return comment;
}

    /**
     * setComment :
     * @param comment 
     */

    @Override
    public void setComment(String comment) {
        this.comment=comment;
        modificationCount++;
}

    /**
     * getLogin :
     * @return String 
     */

    @Override
    public String getLogin() {
        return login;
}

    /**
     * setLogin :
     * @param login 
     */

    @Override
    public void setLogin(String login) {
        this.login=login;
        modificationCount++;
}

    /**
     * getPassword :
     * @return String 
     */

    @Override
    public String getPassword() {
        return password;
}

    /**
     * setPassword :
     * @param password 
     */

    @Override
    public void setPassword(String password) {
        this.password=password;
        modificationCount++;
}

    /**
     * UserDTO :
     */

    public UserDTO() {
}

    /**
     * UserDTO :
     * @param wikittyId 
     */

    public UserDTO(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        return "dto:"+getWikittyId()+":"+getWikittyVersion();
}

    /**
     * getWikittyId :
     * @return String 
     */

    @Override
    public String getWikittyId() {
        return wikittyId;
}

    /**
     * setWikittyId :
     * @param wikittyId 
     */

    public void setWikittyId(String wikittyId) {
        this.wikittyId=wikittyId;
}

    /**
     * getWikittyVersion :
     * @return String 
     */

    @Override
    public String getWikittyVersion() {
        String result = wikittyVersion;
        if (modificationCount > 0) {
            result += "." + modificationCount;
        }
        return result;
}

    /**
     * setWikittyVersion :
     * @param wikittyVersion 
     */

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion=wikittyVersion;
        modificationCount=0;
}

    /**
     * addPropertyChangeListener :
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * addPropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * removePropertyChangeListener :
     * @param property 
     * @param listener 
     */

    @Override
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionFields :
     * @param ext 
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getExtensionNames :
     * @return Collection<String> 
     */

    @Override
    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * getField :
     * @param ext 
     * @param fieldName 
     * @return Object 
     */

    @Override
    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * setField :
     * @param ext 
     * @param fieldName 
     * @param value 
     */

    @Override
    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
}

    /**
     * copyFrom :
     * @param source 
     */

    @Override
    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof User)){
            throw new WikittyException("Can't copy source object " + source +
                    ". They are not of the same type");
        }

        User sourceCopy = (User)source;

        setLogin(sourceCopy.getLogin());

        setPassword(sourceCopy.getPassword());

        setLastName(sourceCopy.getLastName());

        setFirstName(sourceCopy.getFirstName());

        setEmail(sourceCopy.getEmail());

        setComment(sourceCopy.getComment());

        setWikittyVersion(sourceCopy.getWikittyVersion());
}


} //UserDTO
