/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.calculator;

import java.math.BigDecimal;
import java.math.MathContext;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.engine.core.DataException;

public class BigDecimalCalculator
implements ICalculator {
    @Override
    public Number add(Object a, Object b) throws DataException {
        BigDecimal[] args = this.convert(a, b);
        return args[0].add(args[1]);
    }

    @Override
    public Number divide(Object dividend, Object divisor) throws DataException {
        BigDecimal[] args = this.convert(dividend, divisor);
        return args[0].divide(args[1], MathContext.DECIMAL128);
    }

    @Override
    public Number multiply(Object a, Object b) throws DataException {
        BigDecimal[] args = this.convert(a, b);
        return args[0].multiply(args[1]);
    }

    @Override
    public Number safeDivide(Object dividend, Object divisor, Number ifZero) throws DataException {
        try {
            return this.divide(dividend, divisor);
        }
        catch (ArithmeticException arithmeticException) {
            return ifZero;
        }
    }

    @Override
    public Number subtract(Object a, Object b) throws DataException {
        BigDecimal[] args = this.convert(a, b);
        return args[0].subtract(args[1]);
    }

    private BigDecimal[] convert(Object a, Object b) throws DataException {
        BigDecimal[] args = new BigDecimal[]{!(a instanceof BigDecimal) ? BigDecimal.valueOf(((Number)a).doubleValue()) : (BigDecimal)a, !(b instanceof BigDecimal) ? BigDecimal.valueOf(((Number)b).doubleValue()) : (BigDecimal)b};
        return args;
    }

    @Override
    public Object getTypedObject(Object obj) throws DataException {
        try {
            return DataTypeUtil.toBigDecimal(obj);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }
}

