/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.exportactions;

import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportTechnicalActionSupport;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryVesselService;
import fr.ifremer.tutti.service.referential.csv.VesselRow;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryVessel;
import java.util.List;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ExportReferentialVesselAction
extends ExportTechnicalActionSupport {
    private final ReferentialTemporaryVesselService referentialTemporaryVesselService;

    public ExportReferentialVesselAction(ReferentialTemporaryVesselService referentialTemporaryVesselService) {
        this.referentialTemporaryVesselService = referentialTemporaryVesselService;
    }

    @Override
    public void execute(GenericFormatExportContext exportContext) {
        List<Vessel> temporaryVessels = this.referentialTemporaryVesselService.getTemporaryVessels();
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.export.exportTemporaryVessel", (Object[])new Object[]{temporaryVessels.size()}));
        try {
            CsvProducerForTemporaryVessel producerForTemporaryVessel = exportContext.getProducerForTemporaryVessel();
            List<VesselRow> dataToExport = producerForTemporaryVessel.getDataToExport(temporaryVessels);
            producerForTemporaryVessel.write(dataToExport);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException("Could not export temporary vessels", (Throwable)e);
        }
    }
}

