/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.exportactions;

import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportOperationContext;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.csv.MarineLitterRow;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportFishingOperationActionSupport;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForAttachment;
import java.util.ArrayList;
import java.util.List;

public class CreateMarineLitterRowsAction
extends ExportFishingOperationActionSupport {
    private final PersistenceService persistenceService;

    public CreateMarineLitterRowsAction(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public boolean doExecute(GenericFormatExportContext exportContext, GenericFormatExportOperationContext operationContext) {
        return exportContext.isExportMarineLitter() && operationContext.isWithCatchBatch();
    }

    @Override
    public void execute(GenericFormatExportContext exportContext, GenericFormatExportOperationContext operationContext) {
        List<MarineLitterRow> marineLitterRows = exportContext.getProducerForMarineLitter().getDataToExport(operationContext);
        operationContext.setMarineLitterRows(marineLitterRows);
        if (exportContext.isExportAttachments()) {
            List<AttachmentRow> attachmentRows = this.getAttachmentRows(exportContext, operationContext.getRootMarineLitterBatch());
            operationContext.addAttachmentRows(attachmentRows);
        }
    }

    public List<AttachmentRow> getAttachmentRows(GenericFormatExportContext exportContext, BatchContainer<MarineLitterBatch> marineLitterBatches) {
        CsvProducerForAttachment producerForAttachment = exportContext.getProducerForAttachment();
        ArrayList<AttachmentRow> attachmentRows = new ArrayList<AttachmentRow>();
        for (MarineLitterBatch marineLitterBatch : marineLitterBatches.getChildren()) {
            List<Attachment> attachments = this.persistenceService.getAllAttachments(ObjectTypeCode.BATCH, marineLitterBatch.getIdAsInt());
            producerForAttachment.addAttachments(attachments, attachmentRows);
        }
        return attachmentRows;
    }
}

