/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.csv;

import fr.ifremer.tutti.service.csv.AbstractTuttiImportExportModel;
import fr.ifremer.tutti.service.csv.TuttiCsvUtil;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.csv.OperationRow;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

public class OperationModel
extends AbstractTuttiImportExportModel<OperationRow> {
    public static OperationModel forExport(char separator) {
        OperationModel exportModel = new OperationModel(separator);
        exportModel.forExport();
        return exportModel;
    }

    public static OperationModel forImport(char separator, GenericFormatImportEntityParserFactory parserFactory) {
        OperationModel importModel = new OperationModel(separator);
        importModel.forImport(parserFactory);
        return importModel;
    }

    public OperationRow newEmptyInstance() {
        OperationRow row = OperationRow.newEmptyInstance();
        return row;
    }

    protected OperationModel(char separator) {
        super(separator);
    }

    protected void forExport() {
        this.newColumnForExport("Annee", "beginDate", (ValueFormatter)TuttiCsvUtil.YEAR);
        this.newColumnForExport("Serie", "program", TuttiCsvUtil.PROGRAM_FORMATTER);
        this.newColumnForExport("Serie_Partielle", "surveyPart");
        this.newColumnForExport("Code_Station", "stationNumber");
        this.newColumnForExport("Id_Operation", "fishingOperationNumber", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Poche", "multirigAggregation");
        this.newNullableColumnForExport("Engin", "gear", TuttiCsvUtil.GEAR_FORMATTER);
        this.newNullableColumnForExport("Rang_Engin", "gearRankOrder", TuttiCsvUtil.SHORT);
        this.newColumnForExport("Navire", "vessel", TuttiCsvUtil.VESSEL_FORMATTER);
        this.newColumnForExport("DateDeb", "gearShootingStartDate", (ValueFormatter)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newColumnForExport("LatDeb", "gearShootingStartLatitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("LongDeb", "gearShootingStartLongitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("DateFin", "gearShootingEndDate", (ValueFormatter)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newColumnForExport("LatFin", "gearShootingEndLatitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("LongFin", "gearShootingEndLongitude", (ValueFormatter)TuttiCsvUtil.FLOAT);
        this.newColumnForExport("Duree", "duration");
        this.newColumnForExport("Strate", "strata", TuttiCsvUtil.FISHING_OPERATION_STRATA_FORMATTER);
        this.newColumnForExport("Sous_Strate", "subStrata", TuttiCsvUtil.FISHING_OPERATION_SUB_STRATA_FORMATTER);
        this.newColumnForExport("Localite", "location", TuttiCsvUtil.FISHING_OPERATION_LOCATION_FORMATTER);
        this.newColumnForExport("Validite_OP", "fishingOperationValid", (ValueFormatter)TuttiCsvUtil.BOOLEAN);
        this.newColumnForExport("Rectiligne", "fishingOperationRectiligne", (ValueFormatter)TuttiCsvUtil.BOOLEAN);
        this.newColumnForExport("Distance", "trawlDistance", (ValueFormatter)TuttiCsvUtil.INTEGER_NULL_TO_9);
        this.newColumnForExport("Saisisseur", "recorderPerson", TuttiCsvUtil.PERSON_LIST_FORMATTER);
        this.newColumnForExport("Navire_Associe", "secondaryVessel", TuttiCsvUtil.VESSEL_LIST_FORMATTER);
        this.newColumnForExport("Commentaire", "comment", (ValueFormatter)TuttiCsvUtil.COMMENT_PARSER_FORMATTER);
        this.newNullableColumnForExport("Poids_Total", "catchTotalWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Calcule", "catchTotalWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Vrac", "catchTotalSortedWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Vrac_Calcule", "catchTotalSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_HorsVrac", "catchTotalUnsortedWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_HorsVrac_Calcule", "catchTotalUnsortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Non_Trie", "catchTotalRejectedWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Non_Trie_Calcule", "catchTotalRejectedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Tremis", "catchTotalSortedTremisWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Tremis_Calcule", "catchTotalSortedTremisWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Carroussel", "catchTotalSortedCarousselWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Carroussel_Calcule", "catchTotalSortedCarousselWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece", "speciesTotalWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Espece_Calcule", "speciesTotalWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_Vrac", "speciesTotalSortedWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Espece_Vrac_Calcule", "speciesTotalSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_Vrac_Trie", "speciesTotalSampleSortedWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Espece_Vrac_Trie_Calcule", "speciesTotalSampleSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_HorsVrac", "speciesTotalUnsortedWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Espece_HorsVrac_Calcule", "speciesTotalUnsortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_Inerte_Trie", "speciesTotalInertWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Espece_Inerte_Trie_Calcule", "speciesTotalInertWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Espece_Vivant_non_detaille_trie", "speciesTotalLivingNotItemizedWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Espece_Vivant_non_detaille_trie_Calcule", "speciesTotalLivingNotItemizedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos", "benthosTotalWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Benthos_Calcule", "benthosTotalWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vrac", "benthosTotalSortedWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vrac_Calcule", "benthosTotalSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vrac_Trie", "benthosTotalSampleSortedWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vrac_Trie_Calcule", "benthosTotalSampleSortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_HorsVrac", "benthosTotalUnsortedWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Benthos_HorsVrac_Calcule", "benthosTotalUnsortedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_Inerte_Trie", "benthosTotalInertWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Benthos_Inerte_Trie_Calcule", "benthosTotalInertWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vivant_non_detaille_trie", "benthosTotalLivingNotItemizedWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Benthos_Vivant_non_detaille_trie_Calcule", "benthosTotalLivingNotItemizedWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newNullableColumnForExport("Poids_Total_Macro_Dechet", "marineLitterTotalWeight", TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newNullableColumnForExport("Poids_Total_Macro_Dechet_Calcule", "marineLitterTotalWeightComputed", TuttiCsvUtil.BOOLEAN);
        this.newColumnForExport("Serie_Id", "program", TuttiCsvUtil.PROGRAM_TECHNICAL_FORMATTER);
        this.newColumnForExport("Engin_Id", "gear", TuttiCsvUtil.GEAR_TECHNICAL_FORMATTER);
        this.newColumnForExport("Fishing_Operation_Id", "fishingOperationObjectId", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Catch_Lot_Id", "catchObjectId", (ValueFormatter)TuttiCsvUtil.INTEGER);
        this.newColumnForExport("Navire_Id", "vessel", TuttiCsvUtil.VESSEL_TECHNICAL_FORMATTER);
        this.newColumnForExport("Strate_Id", "strata", TuttiCsvUtil.FISHING_OPERATION_STRATA_TECHNICAL_FORMATTER);
        this.newColumnForExport("Sous_Strate_Id", "subStrata", TuttiCsvUtil.FISHING_OPERATION_SUB_STRATA_TECHNICAL_FORMATTER);
        this.newColumnForExport("Localite_Id", "location", TuttiCsvUtil.FISHING_OPERATION_LOCATION_TECHNICAL_FORMATTER);
        this.newColumnForExport("Saisisseur_Id", "recorderPerson", TuttiCsvUtil.PERSON_LIST_TECHNICAL_FORMATTER);
        this.newColumnForExport("Navire_Associe_Id", "secondaryVessel", TuttiCsvUtil.VESSEL_LIST_TECHNICAL_FORMATTER);
    }

    protected void forImport(GenericFormatImportEntityParserFactory parserFactory) {
        this.newMandatoryColumn("Annee", "beginDate", (ValueParser)TuttiCsvUtil.YEAR);
        this.newIgnoredColumn("Serie");
        this.newMandatoryColumn("Serie_Partielle", "surveyPart");
        this.newMandatoryColumn("Code_Station", "stationNumber");
        this.newMandatoryColumn("Id_Operation", "fishingOperationNumber", (ValueParser)TuttiCsvUtil.INTEGER);
        this.newMandatoryColumn("Poche", "multirigAggregation");
        this.newIgnoredColumn("Engin");
        this.newMandatoryColumn("Rang_Engin", "gearRankOrder", (ValueParser)TuttiCsvUtil.SHORT);
        this.newIgnoredColumn("Navire");
        this.newMandatoryColumn("DateDeb", "gearShootingStartDate", (ValueParser)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newMandatoryColumn("LatDeb", "gearShootingStartLatitude", (ValueParser)TuttiCsvUtil.FLOAT);
        this.newMandatoryColumn("LongDeb", "gearShootingStartLongitude", (ValueParser)TuttiCsvUtil.FLOAT);
        this.newMandatoryColumn("DateFin", "gearShootingEndDate", (ValueParser)TuttiCsvUtil.DAY_TIME_SECOND);
        this.newMandatoryColumn("LatFin", "gearShootingEndLatitude", (ValueParser)TuttiCsvUtil.FLOAT);
        this.newMandatoryColumn("LongFin", "gearShootingEndLongitude", (ValueParser)TuttiCsvUtil.FLOAT);
        this.newIgnoredColumn("Duree");
        this.newIgnoredColumn("Strate");
        this.newIgnoredColumn("Sous_Strate");
        this.newIgnoredColumn("Localite");
        this.newMandatoryColumn("Validite_OP", "fishingOperationValid", (ValueParser)TuttiCsvUtil.BOOLEAN);
        this.newMandatoryColumn("Rectiligne", "fishingOperationRectiligne", (ValueParser)TuttiCsvUtil.BOOLEAN);
        this.newMandatoryColumn("Distance", "trawlDistance", (ValueParser)TuttiCsvUtil.INTEGER_NULL_TO_9);
        this.newIgnoredColumn("Saisisseur");
        this.newIgnoredColumn("Navire_Associe");
        this.newMandatoryColumn("Commentaire", "comment", (ValueParser)TuttiCsvUtil.COMMENT_PARSER_FORMATTER);
        this.newMandatoryColumn("Poids_Total", "catchTotalWeight", (ValueParser)TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newMandatoryColumn("Poids_Total_Calcule", "catchTotalWeightComputed", (ValueParser)TuttiCsvUtil.BOOLEAN);
        this.newIgnoredColumn("Poids_Total_Vrac");
        this.newIgnoredColumn("Poids_Total_Vrac_Calcule");
        this.newIgnoredColumn("Poids_Total_HorsVrac");
        this.newIgnoredColumn("Poids_Total_HorsVrac_Calcule");
        this.newMandatoryColumn("Poids_Total_Non_Trie", "catchTotalRejectedWeight", (ValueParser)TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newMandatoryColumn("Poids_Total_Non_Trie_Calcule", "catchTotalRejectedWeightComputed", (ValueParser)TuttiCsvUtil.BOOLEAN);
        this.newMandatoryColumn("Poids_Total_Tremis", "catchTotalSortedTremisWeight", (ValueParser)TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newIgnoredColumn("Poids_Total_Tremis_Calcule");
        this.newMandatoryColumn("Poids_Total_Carroussel", "catchTotalSortedCarousselWeight", (ValueParser)TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newIgnoredColumn("Poids_Total_Carroussel_Calcule");
        this.newIgnoredColumn("Poids_Total_Espece");
        this.newIgnoredColumn("Poids_Total_Espece_Calcule");
        this.newMandatoryColumn("Poids_Total_Espece_Vrac", "speciesTotalSortedWeight", (ValueParser)TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newMandatoryColumn("Poids_Total_Espece_Vrac_Calcule", "speciesTotalSortedWeightComputed", (ValueParser)TuttiCsvUtil.BOOLEAN);
        this.newIgnoredColumn("Poids_Total_Espece_Vrac_Trie");
        this.newIgnoredColumn("Poids_Total_Espece_Vrac_Trie_Calcule");
        this.newIgnoredColumn("Poids_Total_Espece_HorsVrac");
        this.newIgnoredColumn("Poids_Total_Espece_HorsVrac_Calcule");
        this.newMandatoryColumn("Poids_Total_Espece_Inerte_Trie", "speciesTotalInertWeight", (ValueParser)TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newMandatoryColumn("Poids_Total_Espece_Inerte_Trie_Calcule", "speciesTotalInertWeightComputed", (ValueParser)TuttiCsvUtil.BOOLEAN);
        this.newMandatoryColumn("Poids_Total_Espece_Vivant_non_detaille_trie", "speciesTotalLivingNotItemizedWeight", (ValueParser)TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newMandatoryColumn("Poids_Total_Espece_Vivant_non_detaille_trie_Calcule", "speciesTotalLivingNotItemizedWeightComputed", (ValueParser)TuttiCsvUtil.BOOLEAN);
        this.newIgnoredColumn("Poids_Total_Benthos");
        this.newIgnoredColumn("Poids_Total_Benthos_Calcule");
        this.newMandatoryColumn("Poids_Total_Benthos_Vrac", "benthosTotalSortedWeight", (ValueParser)TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newMandatoryColumn("Poids_Total_Benthos_Vrac_Calcule", "benthosTotalSortedWeightComputed", (ValueParser)TuttiCsvUtil.BOOLEAN);
        this.newIgnoredColumn("Poids_Total_Benthos_Vrac_Trie");
        this.newIgnoredColumn("Poids_Total_Benthos_Vrac_Trie_Calcule");
        this.newIgnoredColumn("Poids_Total_Benthos_HorsVrac");
        this.newIgnoredColumn("Poids_Total_Benthos_HorsVrac_Calcule");
        this.newMandatoryColumn("Poids_Total_Benthos_Inerte_Trie", "benthosTotalInertWeight", (ValueParser)TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newMandatoryColumn("Poids_Total_Benthos_Inerte_Trie_Calcule", "benthosTotalInertWeightComputed", (ValueParser)TuttiCsvUtil.BOOLEAN);
        this.newMandatoryColumn("Poids_Total_Benthos_Vivant_non_detaille_trie", "benthosTotalLivingNotItemizedWeight", (ValueParser)TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newMandatoryColumn("Poids_Total_Benthos_Vivant_non_detaille_trie_Calcule", "benthosTotalLivingNotItemizedWeightComputed", (ValueParser)TuttiCsvUtil.BOOLEAN);
        this.newMandatoryColumn("Poids_Total_Macro_Dechet", "marineLitterTotalWeight", (ValueParser)TuttiCsvUtil.WEIGHT_NULL_TO_9);
        this.newMandatoryColumn("Poids_Total_Macro_Dechet_Calcule", "marineLitterTotalWeightComputed", (ValueParser)TuttiCsvUtil.BOOLEAN);
        this.newMandatoryColumn("Serie_Id", "program", (ValueParser)parserFactory.getProgramParser());
        this.newMandatoryColumn("Engin_Id", "gear", (ValueParser)parserFactory.getGearParser());
        this.newMandatoryColumn("Fishing_Operation_Id", "fishingOperationObjectId", (ValueParser)TuttiCsvUtil.INTEGER);
        this.newMandatoryColumn("Catch_Lot_Id", "catchObjectId", (ValueParser)TuttiCsvUtil.INTEGER);
        this.newMandatoryColumn("Navire_Id", "vessel", (ValueParser)parserFactory.getVesselParser());
        this.newMandatoryColumn("Strate_Id", "strata", (ValueParser)parserFactory.getFishingOperationStrataParser());
        this.newMandatoryColumn("Sous_Strate_Id", "subStrata", (ValueParser)parserFactory.getFishingOperationSubStrataParser());
        this.newMandatoryColumn("Localite_Id", "location", (ValueParser)parserFactory.getFishingOperationLocationParser());
        this.newMandatoryColumn("Saisisseur_Id", "recorderPerson", (ValueParser)parserFactory.getPersonListParser());
        this.newMandatoryColumn("Navire_Associe_Id", "secondaryVessel", (ValueParser)parserFactory.getVesselListParser());
    }
}

