/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.model.ProgramDataModel;
import fr.ifremer.tutti.persistence.service.util.SynchronizationStatusHelper;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PdfGeneratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.WeightCleaningService;
import fr.ifremer.tutti.service.genericformat.GenericFormatArchive;
import fr.ifremer.tutti.service.genericformat.GenericFormatArchiveInvalidLayoutException;
import fr.ifremer.tutti.service.genericformat.GenericFormatCheckDataService;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportConfiguration;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportRequest;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatValidateFileContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatValidateFileResult;
import fr.ifremer.tutti.service.genericformat.GenericformatImportPersistenceHelper;
import fr.ifremer.tutti.service.genericformat.importactions.DoCheckWeightAction;
import fr.ifremer.tutti.service.genericformat.importactions.DoCleanWeightAction;
import fr.ifremer.tutti.service.genericformat.importactions.ImportAccidentalCatchAction;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import fr.ifremer.tutti.service.genericformat.importactions.ImportCatchAction;
import fr.ifremer.tutti.service.genericformat.importactions.ImportGearCaracteristicAction;
import fr.ifremer.tutti.service.genericformat.importactions.ImportIndividualObservationAction;
import fr.ifremer.tutti.service.genericformat.importactions.ImportMarineLitterAction;
import fr.ifremer.tutti.service.genericformat.importactions.ImportOperationAction;
import fr.ifremer.tutti.service.genericformat.importactions.ImportParameterAction;
import fr.ifremer.tutti.service.genericformat.importactions.ImportProtocolAction;
import fr.ifremer.tutti.service.genericformat.importactions.ImportReferentialGearAction;
import fr.ifremer.tutti.service.genericformat.importactions.ImportReferentialPersonAction;
import fr.ifremer.tutti.service.genericformat.importactions.ImportReferentialSpeciesAction;
import fr.ifremer.tutti.service.genericformat.importactions.ImportReferentialVesselAction;
import fr.ifremer.tutti.service.genericformat.importactions.ImportSurveyAction;
import fr.ifremer.tutti.service.genericformat.importactions.ImpotSampleCategoryAction;
import fr.ifremer.tutti.service.genericformat.importactions.LoadAttachmentsAction;
import fr.ifremer.tutti.service.genericformat.importactions.ValidateAccidentalCatchAction;
import fr.ifremer.tutti.service.genericformat.importactions.ValidateCatchAction;
import fr.ifremer.tutti.service.genericformat.importactions.ValidateGearCaracteristicAction;
import fr.ifremer.tutti.service.genericformat.importactions.ValidateIndividualObservationAction;
import fr.ifremer.tutti.service.genericformat.importactions.ValidateMarineLitterAction;
import fr.ifremer.tutti.service.genericformat.importactions.ValidateOperationAction;
import fr.ifremer.tutti.service.genericformat.importactions.ValidateParameterAction;
import fr.ifremer.tutti.service.genericformat.importactions.ValidateSurveyAction;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class GenericFormatImportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(GenericFormatImportService.class);
    private PersistenceService persistenceService;
    private PdfGeneratorService pdfGeneratorService;
    private Decorator<FishingOperation> fishingOperationDecorator;
    private Decorator<Cruise> cruiseDecorator;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.pdfGeneratorService = this.getService(PdfGeneratorService.class);
        this.persistenceService = this.getService(PersistenceService.class);
        DecoratorService decoratorService = this.getService(DecoratorService.class);
        this.cruiseDecorator = decoratorService.getDecoratorByType(Cruise.class);
        this.fishingOperationDecorator = decoratorService.getDecoratorByType(FishingOperation.class);
    }

    public int getValidateImportFileNbSteps(GenericFormatImportConfiguration importConfiguration) {
        Preconditions.checkNotNull((Object)importConfiguration);
        GenericFormatArchive archive = this.createArchive(importConfiguration);
        int result = 6 + archive.getSurveyLineCount() + archive.getGearCaracteristicsPathLineCount() + archive.getOperationPathLineCount() + archive.getParameterPathLineCount() + archive.getCatchPathLineCount() + archive.getMarineLitterPathLineCount() + archive.getIndividualObservationPathLineCount() + archive.getAccidentalCatchPathLineCount();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericFormatValidateFileResult validateImportFile(GenericFormatImportConfiguration importConfiguration, ProgressionModel progressionModel) throws GenericFormatArchiveInvalidLayoutException {
        Preconditions.checkNotNull((Object)importConfiguration);
        Preconditions.checkNotNull((Object)progressionModel);
        GenericFormatArchive archive = this.createArchive(importConfiguration);
        GenericFormatImportRequest importRequest = this.createImportRequest(importConfiguration, archive);
        try {
            GenericFormatValidateFileResult result = this.doValidate(importRequest, progressionModel);
            this.generateValidateReport(result, progressionModel);
            GenericFormatValidateFileResult genericFormatValidateFileResult = result;
            return genericFormatValidateFileResult;
        }
        finally {
            TuttiProtocol protocol;
            TuttiProtocol oldProtocol = importRequest.getProtocol();
            if (oldProtocol != null && !(protocol = this.persistenceService.getProtocol()).equals(oldProtocol)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Set back old protocol: " + oldProtocol.getId() + " - " + oldProtocol.getName()));
                }
                this.persistenceService.setProtocol(oldProtocol);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Delete temporary protocol: " + protocol.getId() + " - " + protocol.getName()));
                }
                this.persistenceService.deleteProtocol(protocol.getId());
            }
        }
    }

    public int getImportProgramNbSteps(GenericFormatImportConfiguration importConfiguration) {
        Preconditions.checkNotNull((Object)importConfiguration);
        GenericFormatArchive archive = this.createArchive(importConfiguration);
        int nbCruises = archive.getSurveyLineCount();
        if (log.isInfoEnabled()) {
            log.info((Object)("Count " + nbCruises + " cruises to import."));
        }
        int nbOperations = archive.getOperationPathLineCount();
        if (log.isInfoEnabled()) {
            log.info((Object)("Count " + nbOperations + " operations to import."));
        }
        boolean checkWeights = importConfiguration.isCheckWeights();
        boolean cleanWeights = importConfiguration.isCleanWeights();
        int result = 7 + nbCruises + 1 + nbCruises + 1 + nbOperations + 1 + nbOperations + 1 + nbOperations * 2 + 1 + nbOperations + 1 + nbOperations + 1 + nbOperations + (cleanWeights ? nbOperations : 0) + (checkWeights ? nbOperations : 0) + 1;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericFormatImportResult importProgram(GenericFormatImportConfiguration importConfiguration, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)importConfiguration);
        Preconditions.checkNotNull((Object)progressionModel);
        GenericFormatArchive archive = this.createArchive(importConfiguration);
        archive.validateArchiveLayout();
        GenericFormatImportRequest importRequest = this.createImportRequest(importConfiguration, archive);
        SynchronizationStatusHelper.doNotPropagateDirtyStatusToParents();
        try {
            GenericFormatImportResult result = this.doImport(importRequest, progressionModel);
            this.generateImportReport(result, progressionModel);
            GenericFormatImportResult genericFormatImportResult = result;
            return genericFormatImportResult;
        }
        finally {
            SynchronizationStatusHelper.propagateDirtyStatusToParents();
        }
    }

    protected void generateImportReport(GenericFormatImportResult result, ProgressionModel progressionModel) {
        File reportFile = result.getReportFile();
        progressionModel.increments(I18n.t((String)"tutti.service.genericFormat.import.computeReport", (Object[])new Object[]{reportFile}));
        this.pdfGeneratorService.generatePdf(reportFile, this.context.getConfig().getI18nLocale(), "genericFormatImportReport.ftl", result);
    }

    protected void generateValidateReport(GenericFormatValidateFileResult result, ProgressionModel progressionModel) {
        File reportFile = result.getReportFile();
        progressionModel.increments(I18n.t((String)"tutti.service.genericFormat.validate.computeReport", (Object[])new Object[0]));
        this.pdfGeneratorService.generatePdf(reportFile, this.context.getConfig().getI18nLocale(), "genericFormatValidateReport.ftl", result);
    }

    protected void validateArchiveLayout(GenericFormatContextSupport importContext) {
        try {
            importContext.getImportRequest().getArchive().validateArchiveLayout();
        }
        catch (GenericFormatArchiveInvalidLayoutException e) {
            importContext.setArchiveLayoutErrors(e.getErrors());
        }
    }

    protected GenericFormatValidateFileResult doValidate(GenericFormatImportRequest request, ProgressionModel progressionModel) {
        try (GenericFormatValidateFileContext importContext = new GenericFormatValidateFileContext(request, progressionModel, this.persistenceService, this.cruiseDecorator, this.fishingOperationDecorator);){
            GenericFormatValidateFileResult result;
            this.validateArchiveLayout(importContext);
            if (importContext.isArchiveLayoutValid()) {
                GenericformatImportPersistenceHelper persitenceHelper = new GenericformatImportPersistenceHelper(this.context, importContext);
                Set<ImportActionSupport> actions = this.createValidateActions(importContext, persitenceHelper);
                for (ImportActionSupport action : actions) {
                    action.execute();
                }
            }
            GenericFormatValidateFileResult genericFormatValidateFileResult = result = new GenericFormatValidateFileResult(importContext);
            return genericFormatValidateFileResult;
        }
    }

    protected GenericFormatImportResult doImport(GenericFormatImportRequest request, ProgressionModel progressionModel) {
        try (GenericFormatImportContext importContext = new GenericFormatImportContext(request, progressionModel, this.persistenceService, this.cruiseDecorator, this.fishingOperationDecorator);){
            GenericFormatImportResult result;
            this.validateArchiveLayout(importContext);
            if (importContext.isArchiveLayoutValid()) {
                GenericformatImportPersistenceHelper persitenceHelper = new GenericformatImportPersistenceHelper(this.context, importContext);
                Set<ImportActionSupport> actions = this.createImportActions(importContext, persitenceHelper);
                for (ImportActionSupport action : actions) {
                    action.execute();
                }
            }
            GenericFormatImportResult genericFormatImportResult = result = new GenericFormatImportResult(importContext);
            return genericFormatImportResult;
        }
    }

    protected GenericFormatImportRequest createImportRequest(GenericFormatImportConfiguration importConfiguration, GenericFormatArchive archive) {
        ProgramDataModel dataToExport = importConfiguration.getDataToExport();
        Preconditions.checkNotNull((Object)dataToExport);
        String programId = dataToExport.getId();
        Preconditions.checkNotNull((Object)programId);
        Program program = this.persistenceService.getProgram(programId);
        Preconditions.checkNotNull((Object)program);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will import into program: " + programId));
        }
        LinkedHashSet<Cruise> cruises = new LinkedHashSet<Cruise>();
        for (String cruiseId : this.persistenceService.getAllCruiseId(program.getId())) {
            cruises.add(this.persistenceService.getCruise(cruiseId));
        }
        TuttiProtocol protocol = this.persistenceService.getProtocol();
        ProgramDataModel dataModel = this.persistenceService.loadProgram(programId, true);
        GenericFormatImportRequest request = new GenericFormatImportRequest(importConfiguration, archive, ';', program, this.context.getSampleCategoryModel(), (Set<Cruise>)ImmutableSet.copyOf(cruises), dataModel, protocol);
        return request;
    }

    protected GenericFormatArchive createArchive(GenericFormatImportConfiguration importConfiguration) {
        File importFile = importConfiguration.getImportFile();
        Preconditions.checkNotNull((Object)importFile);
        Preconditions.checkState((boolean)importFile.exists());
        GenericFormatArchive archive = GenericFormatArchive.forImport(importFile, this.context.getConfig().getTmpDirectory());
        return archive;
    }

    protected Set<ImportActionSupport> createValidateActions(GenericFormatValidateFileContext importContext, GenericformatImportPersistenceHelper persitenceHelper) {
        LinkedHashSet<ImportActionSupport> actions = new LinkedHashSet<ImportActionSupport>();
        this.addTechnicalActions(importContext, actions, persitenceHelper);
        actions.add(new LoadAttachmentsAction(importContext));
        actions.add(new ValidateSurveyAction(importContext, persitenceHelper));
        actions.add(new ValidateGearCaracteristicAction(importContext));
        actions.add(new ValidateOperationAction(importContext));
        actions.add(new ValidateParameterAction(importContext));
        actions.add(new ValidateCatchAction(importContext));
        actions.add(new ValidateMarineLitterAction(importContext));
        actions.add(new ValidateAccidentalCatchAction(importContext));
        actions.add(new ValidateIndividualObservationAction(importContext));
        return actions;
    }

    protected Set<ImportActionSupport> createImportActions(GenericFormatImportContext importContext, GenericformatImportPersistenceHelper persitenceHelper) {
        LinkedHashSet<ImportActionSupport> actions = new LinkedHashSet<ImportActionSupport>();
        this.addTechnicalActions(importContext, actions, persitenceHelper);
        actions.add(new LoadAttachmentsAction(importContext));
        actions.add(new ImportSurveyAction(importContext, persitenceHelper));
        actions.add(new ImportGearCaracteristicAction(importContext, persitenceHelper));
        actions.add(new ImportOperationAction(importContext, persitenceHelper));
        actions.add(new ImportParameterAction(importContext, persitenceHelper));
        actions.add(new ImportCatchAction(importContext, persitenceHelper));
        actions.add(new ImportMarineLitterAction(importContext, persitenceHelper));
        actions.add(new ImportAccidentalCatchAction(importContext, persitenceHelper));
        actions.add(new ImportIndividualObservationAction(importContext, persitenceHelper));
        actions.add(new DoCleanWeightAction(importContext, this.context.getService(WeightCleaningService.class)));
        actions.add(new DoCheckWeightAction(importContext, this.context.getService(GenericFormatCheckDataService.class)));
        return actions;
    }

    protected void addTechnicalActions(GenericFormatContextSupport importContext, Set<ImportActionSupport> actions, GenericformatImportPersistenceHelper persitenceHelper) {
        actions.add(new ImpotSampleCategoryAction(importContext, persitenceHelper));
        actions.add(new ImportReferentialGearAction(importContext, persitenceHelper));
        actions.add(new ImportReferentialPersonAction(importContext, persitenceHelper));
        actions.add(new ImportReferentialSpeciesAction(importContext, persitenceHelper));
        actions.add(new ImportReferentialVesselAction(importContext, persitenceHelper));
        actions.add(new ImportProtocolAction(importContext, persitenceHelper));
    }
}

