/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;

public class GenericFormatImportOperationResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final FishingOperation fishingOperation;
    private final CatchBatch catchBatch;
    private final String label;
    private final Set<String> checkErrors;
    private final boolean weightsDeleted;
    private int nbGearFeatures;
    private int nbVesselFeatures;
    private int nbAccidentalCatches;
    private int nbMarineLitters;
    private int nbIndividualObservations;
    private int nbSpeciesBatchesVrac;
    private int nbSpeciesBatchesHorsVrac;
    private int nbBenthosBatchesVrac;
    private int nbBenthosBatchesHorsVrac;
    private final boolean override;

    public GenericFormatImportOperationResult(GenericFormatImportOperationContext operationContext) {
        this.fishingOperation = operationContext.getFishingOperation();
        this.label = operationContext.getFishingOperationLabel();
        this.override = operationContext.isOverride();
        this.catchBatch = operationContext.getCatchBatch();
        this.checkErrors = operationContext.getCheckErrors();
        this.weightsDeleted = operationContext.isWeightsDeleted();
        this.flushContext(operationContext);
    }

    public boolean isOverride() {
        return this.override;
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.fishingOperation.getId();
    }

    public boolean isValid() {
        return BooleanUtils.isTrue((Boolean)this.fishingOperation.getFishingOperationValid());
    }

    public boolean isWithInvalidWeights() {
        return CollectionUtils.isNotEmpty(this.checkErrors);
    }

    public boolean isWeightsDeleted() {
        return this.weightsDeleted;
    }

    public Set<String> getCheckErrors() {
        return this.checkErrors;
    }

    public Float getCatchTotalWeight() {
        return this.catchBatch.getCatchTotalWeight();
    }

    public Float getCatchTotalRejectedWeight() {
        return this.catchBatch.getCatchTotalRejectedWeight();
    }

    public Float getSpeciesTotalSortedWeight() {
        return this.catchBatch.getSpeciesTotalSortedWeight();
    }

    public Float getBenthosTotalSortedWeight() {
        return this.catchBatch.getBenthosTotalSortedWeight();
    }

    public int getNbSpeciesTaxon() {
        return this.nbSpeciesBatchesVrac + this.nbSpeciesBatchesHorsVrac;
    }

    public int getNbBenthosTaxon() {
        return this.nbBenthosBatchesVrac + this.nbBenthosBatchesHorsVrac;
    }

    public boolean isWithAccidentalCatches() {
        return this.nbAccidentalCatches > 0;
    }

    public boolean isWithMarineLitter() {
        return this.nbMarineLitters > 0;
    }

    public FishingOperation getFishingOperation() {
        return this.fishingOperation;
    }

    public CatchBatch getCatchBatch() {
        return this.catchBatch;
    }

    public int getNbGearFeatures() {
        return this.nbGearFeatures;
    }

    public int getNbVesselFeatures() {
        return this.nbVesselFeatures;
    }

    public int getNbAccidentalCatches() {
        return this.nbAccidentalCatches;
    }

    public int getNbMarineLitters() {
        return this.nbMarineLitters;
    }

    public int getNbIndividualObservations() {
        return this.nbIndividualObservations;
    }

    public int getNbSpeciesBatchesVrac() {
        return this.nbSpeciesBatchesVrac;
    }

    public int getNbSpeciesBatchesHorsVrac() {
        return this.nbSpeciesBatchesHorsVrac;
    }

    public int getNbBenthosBatchesVrac() {
        return this.nbBenthosBatchesVrac;
    }

    public int getNbBenthosBatchesHorsVrac() {
        return this.nbBenthosBatchesHorsVrac;
    }

    protected void flushContext(GenericFormatImportOperationContext operationContext) {
        if (operationContext.withGearFeatures()) {
            this.nbGearFeatures = operationContext.getGearUseFeatures().size();
        }
        if (operationContext.withVesselFeatures()) {
            this.nbVesselFeatures = operationContext.getVesselUseFeatures().size();
        }
        if (operationContext.withAccidentalBatches()) {
            this.nbAccidentalCatches = operationContext.getAccidentalBatches().size();
        }
        if (operationContext.withMarineLitterBatches()) {
            this.nbMarineLitters = operationContext.getMarineLitterBatches().size();
        }
        if (operationContext.withIndividualObservationBatches()) {
            this.nbIndividualObservations = operationContext.getIndividualObservationBatches().size();
        }
        if (operationContext.withSpeciesBatches(true)) {
            this.nbSpeciesBatchesVrac = operationContext.getSpeciesBatches(true).size();
        }
        if (operationContext.withSpeciesBatches(false)) {
            this.nbSpeciesBatchesHorsVrac = operationContext.getSpeciesBatches(false).size();
        }
        if (operationContext.withBenthosBatches(true)) {
            this.nbBenthosBatchesVrac = operationContext.getBenthosBatches(true).size();
        }
        if (operationContext.withBenthosBatches(false)) {
            this.nbBenthosBatchesHorsVrac = operationContext.getBenthosBatches(false).size();
        }
    }
}

