/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat.actions;

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportConfiguration;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportService;
import fr.ifremer.tutti.service.genericformat.GenericFormatValidateFileResult;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUI;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUIHandler;
import fr.ifremer.tutti.ui.swing.content.genericformat.GenericFormatImportUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class GenericFormatValidateAction
extends LongActionSupport<GenericFormatImportUIModel, GenericFormatImportUI, GenericFormatImportUIHandler> {
    private static final Log log = LogFactory.getLog(GenericFormatValidateAction.class);
    private GenericFormatValidateFileResult validateFileResult;

    public GenericFormatValidateAction(GenericFormatImportUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            doAction = ((GenericFormatImportUIModel)this.getModel()).isCanValidate();
        }
        if (doAction) {
            this.updateResult(null);
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        ((GenericFormatImportUIModel)this.getModel()).setValidateReportFile(this.getConfig().newTempFile("genericFormatValidateReport", ".pdf"));
        GenericFormatImportConfiguration configuration = ((GenericFormatImportUIModel)this.getModel()).toValidateImportFileConfiguration();
        GenericFormatImportService service = this.getContext().getGenericFormatImportService();
        int nbSteps = service.getValidateImportFileNbSteps(configuration);
        if (log.isInfoEnabled()) {
            log.info((Object)("validate import file nb steps: " + nbSteps));
        }
        this.createProgressionModelIfRequired(nbSteps);
        Program program = ((GenericFormatImportUIModel)this.getModel()).getProgram();
        if (log.isInfoEnabled()) {
            log.info((Object)("Validate generic format import file for program: " + program.getName() + " from file: " + configuration.getImportFile()));
        }
        this.validateFileResult = service.validateImportFile(configuration, this.getProgressionModel());
    }

    public void postSuccessAction() {
        this.updateResult(this.validateFileResult);
    }

    protected void releaseAction() {
        this.validateFileResult = null;
        super.releaseAction();
    }

    protected void updateResult(GenericFormatValidateFileResult result) {
        ((GenericFormatImportUIModel)this.getModel()).setValidateResult(result);
        if (result != null) {
            String tip;
            String text;
            ImageIcon icon;
            if (result.isValid()) {
                icon = SwingUtil.createActionIcon((String)"accept");
                text = I18n.t((String)"tutti.genericFormat.validate.success", (Object[])new Object[0]);
                tip = I18n.t((String)"tutti.genericFormat.validate.success.tip", (Object[])new Object[0]);
            } else {
                icon = SwingUtil.createActionIcon((String)"cancel");
                text = I18n.t((String)"tutti.genericFormat.validate.error", (Object[])new Object[0]);
                tip = I18n.t((String)"tutti.genericFormat.validate.error.tip", (Object[])new Object[0]);
            }
            JLabel resultText = ((GenericFormatImportUI)this.getUI()).getValidateResultText();
            resultText.setIcon(icon);
            resultText.setText(text);
            resultText.setToolTipText(tip);
        }
    }
}

