/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.olap.OLAPException;
import org.eclipse.birt.data.engine.olap.cursor.INavigator;
import org.eclipse.birt.data.engine.olap.cursor.IRowDataAccessor;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.IEdgeAxis;

class EdgeNavigator
implements INavigator {
    private IRowDataAccessor dataAccessor;
    private IAggregationResultSet rs;
    private List warnings;

    EdgeNavigator(IEdgeAxis axis) {
        this.dataAccessor = axis.getRowDataAccessor();
        this.rs = axis.getQueryResultSet();
    }

    @Override
    public void afterLast() throws OLAPException {
        this.dataAccessor.edge_afterLast();
    }

    @Override
    public void beforeFirst() throws OLAPException {
        this.dataAccessor.edge_beforeFirst();
    }

    @Override
    public void close() throws OLAPException {
        try {
            this.rs.close();
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
    }

    @Override
    public boolean first() throws OLAPException {
        return this.dataAccessor.edge_first();
    }

    @Override
    public long getExtend() {
        return 0L;
    }

    @Override
    public long getPosition() throws OLAPException {
        return this.dataAccessor.getEdgePostion();
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public boolean isAfterLast() throws OLAPException {
        return this.dataAccessor.edge_isAfterLast();
    }

    @Override
    public boolean isBeforeFirst() {
        return this.dataAccessor.edge_isBeforeFirst();
    }

    @Override
    public boolean isFirst() throws OLAPException {
        return this.dataAccessor.edge_isFirst();
    }

    @Override
    public boolean isLast() throws OLAPException {
        return this.dataAccessor.edge_isLast();
    }

    @Override
    public boolean last() throws OLAPException {
        return this.dataAccessor.edge_last();
    }

    @Override
    public boolean next() throws OLAPException {
        return this.dataAccessor.edge_next();
    }

    @Override
    public boolean previous() throws OLAPException {
        return this.dataAccessor.edge_previous();
    }

    @Override
    public boolean relative(int arg0) throws OLAPException {
        return this.dataAccessor.edge_relative(arg0);
    }

    @Override
    public void setPosition(long position) throws OLAPException {
        this.dataAccessor.edge_setPostion(position);
    }

    @Override
    public void clearWarnings() throws OLAPException {
        if (this.warnings != null) {
            this.warnings.clear();
        }
    }

    @Override
    public Collection getWarnings() throws OLAPException {
        return this.warnings == null ? new ArrayList() : this.warnings;
    }

    @Override
    public void synchronizedPages(int position) {
        this.dataAccessor.sychronizedWithPage(position);
    }
}

