/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportService;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class ExportGenericFormatProgramCruisesAction
extends LongActionSupport<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {
    private static final Log log = LogFactory.getLog(ExportGenericFormatProgramCruisesAction.class);
    protected File file;

    public ExportGenericFormatProgramCruisesAction(SelectCruiseUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        Program program = ((SelectCruiseUIModel)this.getModel()).getProgram();
        if (doAction) {
            this.file = this.saveFileWithStartDirectory(this.getConfig().getExportBackupDirectory(), false, "exportProgram-" + program.getName(), "zip", I18n.t((String)"tutti.selectCruise.title.choose.exportProgramFile", (Object[])new Object[0]), I18n.t((String)"tutti.selectCruise.action.chooseProgramExportFile", (Object[])new Object[0]), new String[]{"^.+\\.zip$", I18n.t((String)"tutti.common.file.genericFormat", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Program program = ((SelectCruiseUIModel)this.getModel()).getProgram();
        Preconditions.checkNotNull((Object)program);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will save program " + program.getId() + " to file: " + this.file));
        }
        GenericFormatExportService service = this.getContext().getGenericFormatExportService();
        this.createProgressionModelIfRequired(1);
        ProgressionModel progressionModel = this.getProgressionModel();
        progressionModel.increments(I18n.t((String)"tutti.exportProgram.action.computeNbSteps", (Object[])new Object[0]));
        int nbSteps = service.getExportProgramNbSteps(program.getId());
        progressionModel.adaptTotal(nbSteps);
        ApplicationBusinessException exportError = null;
        try {
            service.exportProgram(program.getId(), this.file, progressionModel);
        }
        catch (ApplicationBusinessException e) {
            String errorMessage = I18n.t((String)"tutti.exportProgram.action.exportErrors", (Object[])new Object[]{program.getName(), e.getMessage()});
            exportError = new ApplicationBusinessException(errorMessage);
        }
        ((SelectCruiseUIHandler)this.handler).resetEditProgramAction();
        this.sendMessage(I18n.t((String)"tutti.exportProgram.action.success", (Object[])new Object[]{program.getName(), this.file.getName()}));
        if (exportError != null) {
            throw exportError;
        }
    }
}

