/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.csv;

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatchs;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.service.genericformat.csv.RowWithOperationContextSupport;
import fr.ifremer.tutti.util.DateTimes;
import fr.ifremer.tutti.util.Numbers;
import java.util.Date;
import java.util.List;

public class OperationRow
extends RowWithOperationContextSupport {
    public static final String PROPERTY_GEAR_RANK_ORDER = "gearRankOrder";
    public static final String PROPERTY_DURATION = "duration";
    public static final String PROPERTY_CATCH_TOTAL_WEIGHT = "catchTotalWeight";
    public static final String PROPERTY_CATCH_TOTAL_WEIGHT_COMPUTED = "catchTotalWeightComputed";
    public static final String PROPERTY_CATCH_TOTAL_SORTED_TREMIS_WEIGHT = "catchTotalSortedTremisWeight";
    public static final String PROPERTY_CATCH_TOTAL_SORTED_TREMIS_WEIGHT_COMPUTED = "catchTotalSortedTremisWeightComputed";
    public static final String PROPERTY_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT = "catchTotalSortedCarousselWeight";
    public static final String PROPERTY_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT_COMPUTED = "catchTotalSortedCarousselWeightComputed";
    public static final String PROPERTY_CATCH_TOTAL_SORTED_WEIGHT = "catchTotalSortedWeight";
    public static final String PROPERTY_CATCH_TOTAL_SORTED_WEIGHT_COMPUTED = "catchTotalSortedWeightComputed";
    public static final String PROPERTY_CATCH_TOTAL_UNSORTED_WEIGHT = "catchTotalUnsortedWeight";
    public static final String PROPERTY_CATCH_TOTAL_UNSORTED_WEIGHT_COMPUTED = "catchTotalUnsortedWeightComputed";
    public static final String PROPERTY_CATCH_TOTAL_REJECTED_WEIGHT = "catchTotalRejectedWeight";
    public static final String PROPERTY_CATCH_TOTAL_REJECTED_WEIGHT_COMPUTED = "catchTotalRejectedWeightComputed";
    public static final String PROPERTY_SPECIES_TOTAL_WEIGHT = "speciesTotalWeight";
    public static final String PROPERTY_SPECIES_TOTAL_WEIGHT_COMPUTED = "speciesTotalWeightComputed";
    public static final String PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT = "speciesTotalSortedWeight";
    public static final String PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT_COMPUTED = "speciesTotalSortedWeightComputed";
    public static final String PROPERTY_SPECIES_TOTAL_UNSORTED_WEIGHT = "speciesTotalUnsortedWeight";
    public static final String PROPERTY_SPECIES_TOTAL_UNSORTED_WEIGHT_COMPUTED = "speciesTotalUnsortedWeightComputed";
    public static final String PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT = "speciesTotalSampleSortedWeight";
    public static final String PROPERTY_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_COMPUTED = "speciesTotalSampleSortedWeightComputed";
    public static final String PROPERTY_SPECIES_TOTAL_INERT_WEIGHT = "speciesTotalInertWeight";
    public static final String PROPERTY_SPECIES_TOTAL_INERT_WEIGHT_COMPUTED = "speciesTotalInertWeightComputed";
    public static final String PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT = "speciesTotalLivingNotItemizedWeight";
    public static final String PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_COMPUTED = "speciesTotalLivingNotItemizedWeightComputed";
    public static final String PROPERTY_BENTHOS_TOTAL_WEIGHT = "benthosTotalWeight";
    public static final String PROPERTY_BENTHOS_TOTAL_WEIGHT_COMPUTED = "benthosTotalWeightComputed";
    public static final String PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT = "benthosTotalSortedWeight";
    public static final String PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT_COMPUTED = "benthosTotalSortedWeightComputed";
    public static final String PROPERTY_BENTHOS_TOTAL_UNSORTED_WEIGHT = "benthosTotalUnsortedWeight";
    public static final String PROPERTY_BENTHOS_TOTAL_UNSORTED_WEIGHT_COMPUTED = "benthosTotalUnsortedWeightComputed";
    public static final String PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT = "benthosTotalSampleSortedWeight";
    public static final String PROPERTY_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_COMPUTED = "benthosTotalSampleSortedWeightComputed";
    public static final String PROPERTY_BENTHOS_TOTAL_INERT_WEIGHT = "benthosTotalInertWeight";
    public static final String PROPERTY_BENTHOS_TOTAL_INERT_WEIGHT_COMPUTED = "benthosTotalInertWeightComputed";
    public static final String PROPERTY_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT = "benthosTotalLivingNotItemizedWeight";
    public static final String PROPERTY_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT_COMPUTED = "benthosTotalLivingNotItemizedWeightComputed";
    public static final String PROPERTY_MARINE_LITTER_TOTAL_WEIGHT = "marineLitterTotalWeight";
    public static final String PROPERTY_MARINE_LITTER_TOTAL_WEIGHT_COMPUTED = "marineLitterTotalWeightComputed";
    private static final long serialVersionUID = 1L;
    protected Short gearRankOrder;
    protected CatchBatch catchBatch;
    protected Boolean catchTotalWeightComputed;
    protected Boolean catchTotalRejectedWeightComputed;
    protected Boolean speciesTotalSortedWeightComputed;
    protected Boolean speciesTotalInertWeightComputed;
    protected Boolean speciesTotalLivingNotItemizedWeightComputed;
    protected Boolean benthosTotalSortedWeightComputed;
    protected Boolean benthosTotalInertWeightComputed;
    protected Boolean benthosTotalLivingNotItemizedWeightComputed;
    protected Boolean marineLitterTotalWeightComputed;

    public static OperationRow newEmptyInstance() {
        OperationRow row = new OperationRow();
        row.forImport();
        row.setCatchBatch(CatchBatchs.newCatchBatch());
        return row;
    }

    public void setCatchBatch(CatchBatch catchBatch) {
        if (catchBatch == null) {
            catchBatch = CatchBatchs.newCatchBatch();
        }
        this.catchBatch = catchBatch;
    }

    public void computeCatchValues() {
        this.setCatchTotalWeightComputed(Numbers.getValueOrComputedValueComputed((Number)this.catchBatch.getCatchTotalWeight(), (Number)this.catchBatch.getCatchTotalComputedWeight()));
        this.setCatchTotalRejectedWeightComputed(Numbers.getValueOrComputedValueComputed((Number)this.catchBatch.getCatchTotalRejectedWeight(), (Number)this.catchBatch.getCatchTotalRejectedComputedWeight()));
        this.setSpeciesTotalSortedWeightComputed(Numbers.getValueOrComputedValueComputed((Number)this.catchBatch.getSpeciesTotalSortedWeight(), (Number)this.catchBatch.getSpeciesTotalSortedComputedWeight()));
        this.setSpeciesTotalInertWeightComputed(Numbers.getValueOrComputedValueComputed((Number)this.catchBatch.getSpeciesTotalInertWeight(), (Number)this.catchBatch.getSpeciesTotalInertComputedWeight()));
        this.setSpeciesTotalLivingNotItemizedWeightComputed(Numbers.getValueOrComputedValueComputed((Number)this.catchBatch.getSpeciesTotalLivingNotItemizedWeight(), (Number)this.catchBatch.getSpeciesTotalLivingNotItemizedComputedWeight()));
        this.setBenthosTotalSortedWeightComputed(Numbers.getValueOrComputedValueComputed((Number)this.catchBatch.getBenthosTotalSortedWeight(), (Number)this.catchBatch.getBenthosTotalSortedComputedWeight()));
        this.setBenthosTotalInertWeightComputed(Numbers.getValueOrComputedValueComputed((Number)this.catchBatch.getBenthosTotalInertWeight(), (Number)this.catchBatch.getBenthosTotalInertComputedWeight()));
        this.setBenthosTotalLivingNotItemizedWeightComputed(Numbers.getValueOrComputedValueComputed((Number)this.catchBatch.getBenthosTotalLivingNotItemizedWeight(), (Number)this.catchBatch.getBenthosTotalLivingNotItemizedComputedWeight()));
        this.setMarineLitterTotalWeightComputed(Numbers.getValueOrComputedValueComputed((Number)this.catchBatch.getMarineLitterTotalWeight(), (Number)this.catchBatch.getMarineLitterTotalComputedWeight()));
    }

    public CatchBatch getCatchBatch() {
        return this.catchBatch;
    }

    @Override
    public void setFishingOperation(FishingOperation fishingOperation) {
        super.setFishingOperation(fishingOperation);
        if (this.getGear() != null) {
            this.setGearRankOrder(this.getGear().getRankOrder());
        }
    }

    public void setGear(Gear gear) {
        this.getFishingOperation().setGear(gear);
    }

    public void setGearRankOrder(Short gearRankOrder) {
        this.gearRankOrder = gearRankOrder;
    }

    public void setVessel(Vessel vessel) {
        this.getFishingOperation().setVessel(vessel);
    }

    public void setSubStrata(TuttiLocation subStrata) {
        this.getFishingOperation().setSubStrata(subStrata);
    }

    public void setStrata(TuttiLocation strata) {
        this.getFishingOperation().setStrata(strata);
    }

    public void setRecorderPerson(List<Person> recorderPerson) {
        this.getFishingOperation().setRecorderPerson(recorderPerson);
    }

    public void setLocation(TuttiLocation location) {
        this.getFishingOperation().setLocation(location);
    }

    public void setSecondaryVessel(List<Vessel> secondaryVessel) {
        this.getFishingOperation().setSecondaryVessel(secondaryVessel);
    }

    public void setComment(String comment) {
        this.getFishingOperation().setComment(comment);
    }

    public void setFishingOperationValid(Boolean fishingOperationValid) {
        this.getFishingOperation().setFishingOperationValid(fishingOperationValid);
    }

    public void setTrawlDistance(Integer trawlDistance) {
        this.getFishingOperation().setTrawlDistance(trawlDistance);
    }

    public void setFishingOperationRectiligne(boolean fishingOperationRectiligne) {
        this.getFishingOperation().setFishingOperationRectiligne(fishingOperationRectiligne);
    }

    public void setGearShootingEndDate(Date gearShootingEndDate) {
        this.getFishingOperation().setGearShootingEndDate(gearShootingEndDate);
    }

    public void setGearShootingEndLongitude(Float gearShootingEndLongitude) {
        this.getFishingOperation().setGearShootingEndLongitude(gearShootingEndLongitude);
    }

    public void setGearShootingEndLatitude(Float gearShootingEndLatitude) {
        this.getFishingOperation().setGearShootingEndLatitude(gearShootingEndLatitude);
    }

    public void setGearShootingStartDate(Date gearShootingStartDate) {
        this.getFishingOperation().setGearShootingStartDate(gearShootingStartDate);
    }

    public void setGearShootingStartLongitude(Float gearShootingStartLongitude) {
        this.getFishingOperation().setGearShootingStartLongitude(gearShootingStartLongitude);
    }

    public void setGearShootingStartLatitude(Float gearShootingStartLatitude) {
        this.getFishingOperation().setGearShootingStartLatitude(gearShootingStartLatitude);
    }

    public void setBenthosTotalLivingNotItemizedWeight(Float benthosTotalLivingNotItemizedWeight) {
        this.catchBatch.setBenthosTotalLivingNotItemizedWeight(benthosTotalLivingNotItemizedWeight);
    }

    public void setCatchTotalRejectedWeight(Float catchTotalRejectedWeight) {
        this.catchBatch.setCatchTotalRejectedWeight(catchTotalRejectedWeight);
    }

    public void setMarineLitterTotalWeight(Float marineLitterTotalWeight) {
        this.catchBatch.setMarineLitterTotalWeight(marineLitterTotalWeight);
    }

    public void setBenthosTotalInertWeight(Float benthosTotalInertWeight) {
        this.catchBatch.setBenthosTotalInertWeight(benthosTotalInertWeight);
    }

    public void setCatchTotalSortedTremisWeight(Float catchTotalSortedTremisWeight) {
        this.catchBatch.setCatchTotalSortedTremisWeight(catchTotalSortedTremisWeight);
    }

    public void setCatchTotalWeight(Float catchTotalWeight) {
        this.catchBatch.setCatchTotalWeight(catchTotalWeight);
    }

    public void setBenthosTotalSortedWeight(Float benthosTotalSortedWeight) {
        this.catchBatch.setBenthosTotalSortedWeight(benthosTotalSortedWeight);
    }

    public void setCatchTotalSortedCarousselWeight(Float catchTotalSortedCarousselWeight) {
        this.catchBatch.setCatchTotalSortedCarousselWeight(catchTotalSortedCarousselWeight);
    }

    public void setSpeciesTotalSortedWeight(Float speciesTotalSortedWeight) {
        this.catchBatch.setSpeciesTotalSortedWeight(speciesTotalSortedWeight);
    }

    public void setSpeciesTotalLivingNotItemizedWeight(Float speciesTotalLivingNotItemizedWeight) {
        this.catchBatch.setSpeciesTotalLivingNotItemizedWeight(speciesTotalLivingNotItemizedWeight);
    }

    public void setSpeciesTotalInertWeight(Float speciesTotalInertWeight) {
        this.catchBatch.setSpeciesTotalInertWeight(speciesTotalInertWeight);
    }

    public Short getGearRankOrder() {
        return this.gearRankOrder;
    }

    public Gear getGear() {
        return this.getFishingOperation().getGear();
    }

    public Vessel getVessel() {
        return this.getFishingOperation().getVessel();
    }

    public Date getGearShootingStartDate() {
        return this.getFishingOperation().getGearShootingStartDate();
    }

    public Float getGearShootingStartLatitude() {
        return this.getFishingOperation().getGearShootingStartLatitude();
    }

    public Float getGearShootingStartLongitude() {
        return this.getFishingOperation().getGearShootingStartLongitude();
    }

    public Date getGearShootingEndDate() {
        return this.getFishingOperation().getGearShootingEndDate();
    }

    public Float getGearShootingEndLatitude() {
        return this.getFishingOperation().getGearShootingEndLatitude();
    }

    public Float getGearShootingEndLongitude() {
        return this.getFishingOperation().getGearShootingEndLongitude();
    }

    public TuttiLocation getStrata() {
        return this.getFishingOperation().getStrata();
    }

    public TuttiLocation getSubStrata() {
        return this.getFishingOperation().getSubStrata();
    }

    public TuttiLocation getLocation() {
        return this.getFishingOperation().getLocation();
    }

    public Boolean getFishingOperationValid() {
        return this.getFishingOperation().getFishingOperationValid();
    }

    public boolean isFishingOperationRectiligne() {
        return this.getFishingOperation().isFishingOperationRectiligne();
    }

    public Integer getTrawlDistance() {
        return this.getFishingOperation().getTrawlDistance();
    }

    public String getComment() {
        return this.getFishingOperation().getComment();
    }

    public List<Person> getRecorderPerson() {
        return this.getFishingOperation().getRecorderPerson();
    }

    public List<Vessel> getSecondaryVessel() {
        return this.getFishingOperation().getSecondaryVessel();
    }

    public String getDuration() {
        return DateTimes.getDuration((Date)this.getGearShootingStartDate(), (Date)this.getGearShootingEndDate(), (String)"mm");
    }

    public Float getCatchTotalWeight() {
        return (Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getCatchTotalWeight(), (Number)this.catchBatch.getCatchTotalComputedWeight());
    }

    public Float getCatchTotalSortedTremisWeight() {
        return this.catchBatch.getCatchTotalSortedTremisWeight();
    }

    public Float getCatchTotalSortedCarousselWeight() {
        return this.catchBatch.getCatchTotalSortedCarousselWeight();
    }

    public Float getCatchTotalSortedWeight() {
        return this.catchBatch.getCatchTotalSortedComputedWeight();
    }

    public Float getCatchTotalUnsortedWeight() {
        return this.catchBatch.getCatchTotalUnsortedComputedWeight();
    }

    public Float getCatchTotalRejectedWeight() {
        return (Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getCatchTotalRejectedWeight(), (Number)this.catchBatch.getCatchTotalRejectedComputedWeight());
    }

    public Float getSpeciesTotalWeight() {
        return this.catchBatch.getSpeciesTotalComputedWeight();
    }

    public Float getSpeciesTotalSortedWeight() {
        return (Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getSpeciesTotalSortedWeight(), (Number)this.catchBatch.getSpeciesTotalSortedComputedWeight());
    }

    public Float getSpeciesTotalUnsortedWeight() {
        return this.catchBatch.getSpeciesTotalUnsortedComputedWeight();
    }

    public Float getSpeciesTotalSampleSortedWeight() {
        return (Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getSpeciesTotalSampleSortedComputedWeight(), (Number)this.catchBatch.getSpeciesTotalSampleSortedComputedWeight());
    }

    public Float getSpeciesTotalLivingNotItemizedWeight() {
        return (Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getSpeciesTotalLivingNotItemizedWeight(), (Number)this.catchBatch.getSpeciesTotalLivingNotItemizedComputedWeight());
    }

    public Float getSpeciesTotalInertWeight() {
        return (Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getSpeciesTotalInertWeight(), (Number)this.catchBatch.getSpeciesTotalInertComputedWeight());
    }

    public Float getBenthosTotalWeight() {
        return this.catchBatch.getBenthosTotalComputedWeight();
    }

    public Float getBenthosTotalSortedWeight() {
        return (Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getBenthosTotalSortedWeight(), (Number)this.catchBatch.getBenthosTotalSortedComputedWeight());
    }

    public Float getBenthosTotalUnsortedWeight() {
        return this.catchBatch.getBenthosTotalUnsortedComputedWeight();
    }

    public Float getBenthosTotalInertWeight() {
        return (Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getBenthosTotalInertWeight(), (Number)this.catchBatch.getBenthosTotalInertComputedWeight());
    }

    public Float getBenthosTotalSampleSortedWeight() {
        return this.catchBatch.getBenthosTotalSampleSortedComputedWeight();
    }

    public Float getBenthosTotalLivingNotItemizedWeight() {
        return (Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getBenthosTotalLivingNotItemizedWeight(), (Number)this.catchBatch.getBenthosTotalLivingNotItemizedComputedWeight());
    }

    public Float getMarineLitterTotalWeight() {
        return (Float)Numbers.getValueOrComputedValue((Number)this.catchBatch.getMarineLitterTotalWeight(), (Number)this.catchBatch.getMarineLitterTotalComputedWeight());
    }

    public boolean isCatchTotalSortedTremisWeightComputed() {
        return false;
    }

    public boolean isCatchTotalSortedCarousselWeightComputed() {
        return false;
    }

    public boolean isCatchTotalSortedWeightComputed() {
        return true;
    }

    public boolean isCatchTotalUnsortedWeightComputed() {
        return true;
    }

    public boolean isSpeciesTotalWeightComputed() {
        return true;
    }

    public boolean isSpeciesTotalUnsortedWeightComputed() {
        return true;
    }

    public boolean isSpeciesTotalSampleSortedWeightComputed() {
        return true;
    }

    public boolean isBenthosTotalWeightComputed() {
        return true;
    }

    public boolean isBenthosTotalUnsortedWeightComputed() {
        return true;
    }

    public boolean isBenthosTotalSampleSortedWeightComputed() {
        return true;
    }

    public Boolean getCatchTotalWeightComputed() {
        return this.catchTotalWeightComputed;
    }

    public Boolean getCatchTotalRejectedWeightComputed() {
        return this.catchTotalRejectedWeightComputed;
    }

    public Boolean getSpeciesTotalSortedWeightComputed() {
        return this.speciesTotalSortedWeightComputed;
    }

    public Boolean getSpeciesTotalInertWeightComputed() {
        return this.speciesTotalInertWeightComputed;
    }

    public Boolean getSpeciesTotalLivingNotItemizedWeightComputed() {
        return this.speciesTotalLivingNotItemizedWeightComputed;
    }

    public Boolean getBenthosTotalSortedWeightComputed() {
        return this.benthosTotalSortedWeightComputed;
    }

    public Boolean getBenthosTotalInertWeightComputed() {
        return this.benthosTotalInertWeightComputed;
    }

    public Boolean getBenthosTotalLivingNotItemizedWeightComputed() {
        return this.benthosTotalLivingNotItemizedWeightComputed;
    }

    public Boolean getMarineLitterTotalWeightComputed() {
        return this.marineLitterTotalWeightComputed;
    }

    public void setCatchTotalWeightComputed(Boolean catchTotalWeightComputed) {
        this.catchTotalWeightComputed = catchTotalWeightComputed;
    }

    public void setCatchTotalRejectedWeightComputed(Boolean catchTotalRejectedWeightComputed) {
        this.catchTotalRejectedWeightComputed = catchTotalRejectedWeightComputed;
    }

    public void setSpeciesTotalSortedWeightComputed(Boolean speciesTotalSortedWeightComputed) {
        this.speciesTotalSortedWeightComputed = speciesTotalSortedWeightComputed;
    }

    public void setSpeciesTotalInertWeightComputed(Boolean speciesTotalInertWeightComputed) {
        this.speciesTotalInertWeightComputed = speciesTotalInertWeightComputed;
    }

    public void setSpeciesTotalLivingNotItemizedWeightComputed(Boolean speciesTotalLivingNotItemizedWeightComputed) {
        this.speciesTotalLivingNotItemizedWeightComputed = speciesTotalLivingNotItemizedWeightComputed;
    }

    public void setBenthosTotalSortedWeightComputed(Boolean benthosTotalSortedWeightComputed) {
        this.benthosTotalSortedWeightComputed = benthosTotalSortedWeightComputed;
    }

    public void setBenthosTotalInertWeightComputed(Boolean benthosTotalInertWeightComputed) {
        this.benthosTotalInertWeightComputed = benthosTotalInertWeightComputed;
    }

    public void setBenthosTotalLivingNotItemizedWeightComputed(Boolean benthosTotalLivingNotItemizedWeightComputed) {
        this.benthosTotalLivingNotItemizedWeightComputed = benthosTotalLivingNotItemizedWeightComputed;
    }

    public void setMarineLitterTotalWeightComputed(Boolean marineLitterTotalWeightComputed) {
        this.marineLitterTotalWeightComputed = marineLitterTotalWeightComputed;
    }
}

