/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Cruises;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.genericformat.GenericFormatArchive;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportConfiguration;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;

public class GenericFormatImportRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final GenericFormatImportConfiguration importConfiguration;
    private final GenericFormatArchive archive;
    private final char csvSeparator;
    private final SampleCategoryModel sampleCategoryModel;
    private final Set<Cruise> existingCruises;
    private final TuttiProtocol protocol;
    private final Program program;
    private final Date startingDate;

    public GenericFormatImportRequest(GenericFormatImportConfiguration importConfiguration, GenericFormatArchive archive, char csvSeparator, Program program, SampleCategoryModel sampleCategoryModel, Set<Cruise> cruises, TuttiProtocol protocol) {
        this.importConfiguration = importConfiguration;
        this.archive = archive;
        this.csvSeparator = csvSeparator;
        this.sampleCategoryModel = sampleCategoryModel;
        this.program = program;
        this.existingCruises = cruises;
        this.protocol = protocol;
        this.startingDate = new Date();
    }

    public GenericFormatArchive getArchive() {
        return this.archive;
    }

    public char getCsvSeparator() {
        return this.csvSeparator;
    }

    public SampleCategoryModel getSampleCategoryModel() {
        return this.sampleCategoryModel;
    }

    public Set<Cruise> getExistingCruises() {
        return this.existingCruises;
    }

    public TuttiProtocol getProtocol() {
        return this.protocol;
    }

    public Program getProgram() {
        return this.program;
    }

    public Date getStartingDate() {
        return this.startingDate;
    }

    public GenericFormatImportConfiguration getImportConfiguration() {
        return this.importConfiguration;
    }

    public Cruise getExistingCruise(Cruise importRowCruise) {
        Cruise result = null;
        for (Cruise cruise : this.existingCruises) {
            boolean equals = Cruises.equals((Cruise)importRowCruise, (Cruise)cruise);
            if (!equals) continue;
            result = cruise;
            break;
        }
        return result;
    }

    public boolean isCleanWeights() {
        return this.importConfiguration.isCleanWeights();
    }

    public boolean isCheckWeights() {
        return this.importConfiguration.isCheckWeights();
    }

    public boolean isOverrideData() {
        return this.importConfiguration.isOverrideData();
    }

    public boolean isOverrideProtocol() {
        return this.importConfiguration.isOverrideProtocol();
    }

    public File getReportFile() {
        return this.importConfiguration.getReportFile();
    }
}

