/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.genericformat;

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportConfiguration;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportResult;
import fr.ifremer.tutti.service.genericformat.GenericFormatValidateFileResult;
import java.io.File;
import org.jdesktop.beans.AbstractSerializableBean;

public class GenericFormatImportUIModel
extends AbstractSerializableBean {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_PROGRAM = "program";
    public static final String PROPERTY_IMPORT_FILE = "importFile";
    public static final String PROPERTY_BACKUP_FILE = "backupFile";
    public static final String PROPERTY_CLEAN_WEIGHTS = "cleanWeights";
    public static final String PROPERTY_CHECK_WEIGHTS = "checkWeights";
    public static final String PROPERTY_OVERRIDE_DATA = "overrideData";
    public static final String PROPERTY_CAN_VALIDATE = "canValidate";
    public static final String PROPERTY_VALIDATE_RESULT = "validateResult";
    public static final String PROPERTY_VALIDATE_VALID = "validateValid";
    public static final String PROPERTY_VALIDATE_DONE = "validateDone";
    public static final String PROPERTY_CAN_IMPORT = "canImport";
    public static final String PROPERTY_IMPORT_RESULT = "importResult";
    public static final String PROPERTY_IMPORT_DONE = "importDone";
    public static final String PROPERTY_IMPORT_VALID = "importValid";
    private Program program;
    private File importFile;
    private boolean cleanWeights;
    private boolean checkWeights;
    private boolean overrideData;
    private boolean canValidate;
    private File validateReportFile;
    private GenericFormatValidateFileResult validateResult;
    private boolean canImport;
    private File importReportFile;
    private GenericFormatImportResult importResult;

    public GenericFormatImportConfiguration toValidateImportFileConfiguration() {
        GenericFormatImportConfiguration configuration = new GenericFormatImportConfiguration();
        configuration.setCleanWeights(this.cleanWeights);
        configuration.setCheckWeights(this.checkWeights);
        configuration.setOverrideData(this.overrideData);
        configuration.setImportFile(this.importFile);
        configuration.setReportFile(this.validateReportFile);
        configuration.setProgramId(this.program.getId());
        return configuration;
    }

    public GenericFormatImportConfiguration toImportConfiguration() {
        GenericFormatImportConfiguration configuration = new GenericFormatImportConfiguration();
        configuration.setCleanWeights(this.cleanWeights);
        configuration.setCheckWeights(this.checkWeights);
        configuration.setOverrideData(this.overrideData);
        configuration.setImportFile(this.importFile);
        configuration.setReportFile(this.importReportFile);
        configuration.setProgramId(this.program.getId());
        return configuration;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        Program oldValue = this.getProgram();
        this.program = program;
        this.firePropertyChange(PROPERTY_PROGRAM, oldValue, program);
    }

    public File getImportFile() {
        return this.importFile;
    }

    public void setImportFile(File importFile) {
        File oldValue = this.getImportFile();
        this.importFile = importFile;
        this.firePropertyChange(PROPERTY_IMPORT_FILE, oldValue, importFile);
        this.firePropertyChange(PROPERTY_VALIDATE_VALID, null, this.isValidateValid());
    }

    public boolean isCleanWeights() {
        return this.cleanWeights;
    }

    public void setCleanWeights(boolean cleanWeights) {
        this.cleanWeights = cleanWeights;
        this.firePropertyChange(PROPERTY_CLEAN_WEIGHTS, null, cleanWeights);
    }

    public boolean isCheckWeights() {
        return this.checkWeights;
    }

    public void setCheckWeights(boolean checkWeights) {
        this.checkWeights = checkWeights;
        this.firePropertyChange(PROPERTY_CHECK_WEIGHTS, null, checkWeights);
    }

    public boolean isOverrideData() {
        return this.overrideData;
    }

    public void setOverrideData(boolean overrideData) {
        this.overrideData = overrideData;
        this.firePropertyChange(PROPERTY_OVERRIDE_DATA, null, overrideData);
    }

    public File getValidateReportFile() {
        return this.validateReportFile;
    }

    public void setValidateReportFile(File validateReportFile) {
        this.validateReportFile = validateReportFile;
    }

    public boolean isCanValidate() {
        return this.canValidate;
    }

    public void setCanValidate(boolean canValidate) {
        this.canValidate = canValidate;
        this.firePropertyChange(PROPERTY_CAN_VALIDATE, null, canValidate);
    }

    public GenericFormatValidateFileResult getValidateResult() {
        return this.validateResult;
    }

    public void setValidateResult(GenericFormatValidateFileResult validateResult) {
        this.validateResult = validateResult;
        this.firePropertyChange(PROPERTY_VALIDATE_RESULT, null, validateResult);
        this.firePropertyChange(PROPERTY_VALIDATE_DONE, null, this.isValidateDone());
        this.firePropertyChange(PROPERTY_VALIDATE_VALID, null, this.isValidateValid());
    }

    public boolean isValidateDone() {
        return this.validateResult != null;
    }

    public boolean isValidateValid() {
        return this.validateResult != null && this.validateResult.isValid();
    }

    public boolean isCanImport() {
        return this.canImport;
    }

    public void setCanImport(boolean canImport) {
        this.canImport = canImport;
        this.firePropertyChange(PROPERTY_CAN_IMPORT, null, canImport);
    }

    public File getImportReportFile() {
        return this.importReportFile;
    }

    public void setImportReportFile(File importReportFile) {
        this.importReportFile = importReportFile;
    }

    public GenericFormatImportResult getImportResult() {
        return this.importResult;
    }

    public void setImportResult(GenericFormatImportResult importResult) {
        this.importResult = importResult;
        this.firePropertyChange(PROPERTY_IMPORT_RESULT, null, importResult);
        this.firePropertyChange(PROPERTY_IMPORT_DONE, null, this.isImportDone());
        this.firePropertyChange(PROPERTY_IMPORT_VALID, null, this.isImportValid());
    }

    public boolean isImportDone() {
        return this.importResult != null;
    }

    public boolean isImportValid() {
        return this.importResult != null && this.importResult.isValid();
    }

    public boolean computeIsCanValidate() {
        return this.program != null && this.importFile != null && this.importFile.exists();
    }

    public boolean computeIsCanImport() {
        return this.isValidateDone() && this.isValidateValid();
    }
}

