/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.nuiton.csv.ValueGetter;

public class BeanIndexNullableGetter<E, T>
implements ValueGetter<E, T> {
    protected String collectionName;
    protected int order;
    protected String propertyName;

    BeanIndexNullableGetter(String collectionName, int order, String suffix) {
        this.collectionName = collectionName;
        this.order = order;
        this.propertyName = collectionName + "[" + order + "]." + suffix;
    }

    public T get(E object) throws Exception {
        Object value = null;
        try {
            Collection c = (Collection)PropertyUtils.getProperty(object, (String)this.collectionName);
            if (c != null && this.order < c.size()) {
                value = PropertyUtils.getProperty(object, (String)this.propertyName);
            }
        }
        catch (NestedNullException e) {
            value = null;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof NullPointerException) {
                value = null;
            }
            throw e;
        }
        return (T)value;
    }
}

