/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import org.eclipse.birt.report.engine.api.DataSetID;

public class DataID {
    protected DataSetID dataSet;
    protected long rowId = -1L;
    protected String cellId;

    public DataID(DataSetID dataSet, long rowId) {
        this.dataSet = dataSet;
        this.rowId = rowId;
    }

    public DataID(DataSetID dataSet, String cellId) {
        this.dataSet = dataSet;
        this.cellId = cellId;
    }

    public DataSetID getDataSetID() {
        return this.dataSet;
    }

    public long getRowID() {
        return this.rowId;
    }

    public String getCellID() {
        return this.cellId;
    }

    public void append(StringBuffer buffer) {
        if (this.dataSet != null) {
            this.dataSet.append(buffer);
        }
        buffer.append(':');
        if (this.rowId != -1L) {
            buffer.append(this.rowId);
        } else {
            buffer.append(this.cellId);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.append(buffer);
        return buffer.toString();
    }

    public boolean equals(Object a) {
        if (a instanceof DataID) {
            DataID aid = (DataID)a;
            if (this.rowId == -1L && aid.rowId == -1L ? (this.cellId != null ? !this.cellId.equals(aid.cellId) : aid.cellId != null) : this.rowId != aid.rowId) {
                return false;
            }
            return this.dataSet.equals(aid.dataSet);
        }
        return false;
    }

    public static DataID parse(String dataId) {
        return DataID.parse(dataId.toCharArray(), 0, dataId.length());
    }

    static DataID parse(char[] buffer, int offset, int length) {
        int ptr = offset + length - 1;
        while (ptr >= offset) {
            if (buffer[ptr] != ':') {
                --ptr;
                continue;
            }
            if (ptr <= offset || buffer[ptr - 1] != ':') break;
            --ptr;
            --ptr;
        }
        if (ptr >= offset && buffer[ptr] == ':') {
            DataSetID dataSetId;
            String strRowId = new String(buffer, ptr + 1, offset + length - ptr - 1);
            if (--ptr >= offset && (dataSetId = DataSetID.parse(buffer, offset, ptr - offset + 1)) != null) {
                try {
                    long rowId = Long.parseLong(strRowId);
                    return new DataID(dataSetId, rowId);
                }
                catch (Exception exception) {
                    return new DataID(dataSetId, strRowId);
                }
            }
        }
        return null;
    }
}

