/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import java.util.Iterator;
import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.UniqueConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

public class UniqueConstraintSnapshotGenerator
extends HibernateSnapshotGenerator {
    public UniqueConstraintSnapshotGenerator() {
        super(UniqueConstraint.class, new Class[]{liquibase.structure.core.Table.class});
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(UniqueConstraint.class)) {
            return;
        }
        if (foundObject instanceof liquibase.structure.core.Table) {
            liquibase.structure.core.Table table = (liquibase.structure.core.Table)foundObject;
            Table hibernateTable = this.findHibernateTable((DatabaseObject)table, snapshot);
            Iterator uniqueIterator = hibernateTable.getUniqueKeyIterator();
            while (uniqueIterator.hasNext()) {
                UniqueKey hibernateUnique = (UniqueKey)uniqueIterator.next();
                UniqueConstraint uniqueConstraint = new UniqueConstraint();
                String name = "UC_" + table.getName().toUpperCase();
                uniqueConstraint.setTable(table);
                Iterator columnIterator = hibernateUnique.getColumnIterator();
                int i = 0;
                while (columnIterator.hasNext()) {
                    Column hibernateColumn = (Column)columnIterator.next();
                    name = String.valueOf(name) + "_" + hibernateColumn.getName().toUpperCase();
                    uniqueConstraint.addColumn(i, hibernateColumn.getName());
                    ++i;
                }
                uniqueConstraint.setName(name);
                LOG.info("Found unique constraint " + uniqueConstraint.toString());
                table.getUniqueConstraints().add(uniqueConstraint);
            }
            Iterator columnIterator = hibernateTable.getColumnIterator();
            while (columnIterator.hasNext()) {
                Column column = (Column)columnIterator.next();
                if (!column.isUnique()) continue;
                UniqueConstraint uniqueConstraint = new UniqueConstraint();
                uniqueConstraint.setTable(table);
                String name = "UC_" + table.getName().toUpperCase() + column.getName().toUpperCase() + "_COL";
                uniqueConstraint.addColumn(0, column.getName());
                uniqueConstraint.setName(name);
                LOG.info("Found unique constraint " + uniqueConstraint.toString());
                table.getUniqueConstraints().add(uniqueConstraint);
            }
        }
    }
}

