/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.servicelocator.ServiceLocator;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorComparator;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;

public class SqlGeneratorFactory {
    private static SqlGeneratorFactory instance;
    private List<SqlGenerator> generators = new ArrayList<SqlGenerator>();
    private final Map<Class<?>, Type[]> genericInterfacesCache = new HashMap();
    private final Map<Class<?>, Type> genericSuperClassCache = new HashMap();
    private Map<String, SortedSet<SqlGenerator>> generatorsByKey = new HashMap<String, SortedSet<SqlGenerator>>();

    private SqlGeneratorFactory() {
        try {
            Class<SqlGenerator>[] classes;
            Class<SqlGenerator>[] classArray = classes = ServiceLocator.getInstance().findClasses(SqlGenerator.class);
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<SqlGenerator> clazz = classArray[n2];
                this.register(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                ++n2;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SqlGeneratorFactory getInstance() {
        if (instance == null) {
            instance = new SqlGeneratorFactory();
        }
        return instance;
    }

    public static void reset() {
        instance = new SqlGeneratorFactory();
    }

    public void register(SqlGenerator generator) {
        this.generators.add(generator);
    }

    public void unregister(SqlGenerator generator) {
        this.generators.remove(generator);
    }

    public void unregister(Class generatorClass) {
        SqlGenerator toRemove = null;
        for (SqlGenerator existingGenerator : this.generators) {
            if (!existingGenerator.getClass().equals(generatorClass)) continue;
            toRemove = existingGenerator;
        }
        this.unregister(toRemove);
    }

    protected Collection<SqlGenerator> getGenerators() {
        return this.generators;
    }

    protected SortedSet<SqlGenerator> getGenerators(SqlStatement statement, Database database) {
        String databaseName = null;
        databaseName = database == null ? "NULL" : database.getShortName();
        String key = String.valueOf(statement.getClass().getName()) + ":" + databaseName;
        if (this.generatorsByKey.containsKey(key)) {
            return this.generatorsByKey.get(key);
        }
        TreeSet<SqlGenerator> validGenerators = new TreeSet<SqlGenerator>(new SqlGeneratorComparator());
        for (SqlGenerator generator : this.getGenerators()) {
            Class<?> clazz = generator.getClass();
            Type classType = null;
            while (clazz != null) {
                if (classType instanceof ParameterizedType) {
                    this.checkType(classType, statement, generator, database, validGenerators);
                }
                Type[] typeArray = this.getGenericInterfaces(clazz);
                int n = typeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Type type = typeArray[n2];
                    if (type instanceof ParameterizedType) {
                        this.checkType(type, statement, generator, database, validGenerators);
                    } else if (this.isTypeEqual(type, SqlGenerator.class) && generator.supports(statement, database)) {
                        validGenerators.add(generator);
                    }
                    ++n2;
                }
                classType = this.getGenericSuperclass(clazz);
                clazz = clazz.getSuperclass();
            }
        }
        this.generatorsByKey.put(key, validGenerators);
        return validGenerators;
    }

    private Type[] getGenericInterfaces(Class<?> clazz) {
        if (this.genericInterfacesCache.containsKey(clazz)) {
            return this.genericInterfacesCache.get(clazz);
        }
        Type[] genericInterfaces = clazz.getGenericInterfaces();
        this.genericInterfacesCache.put(clazz, genericInterfaces);
        return genericInterfaces;
    }

    private Type getGenericSuperclass(Class<?> clazz) {
        if (this.genericSuperClassCache.containsKey(clazz)) {
            return this.genericSuperClassCache.get(clazz);
        }
        Type genericSuperclass = clazz.getGenericSuperclass();
        this.genericSuperClassCache.put(clazz, genericSuperclass);
        return genericSuperclass;
    }

    private boolean isTypeEqual(Type aType, Class aClass) {
        if (aType instanceof Class) {
            return ((Class)aType).getName().equals(aClass.getName());
        }
        return aType.equals(aClass);
    }

    private void checkType(Type type, SqlStatement statement, SqlGenerator generator, Database database, SortedSet<SqlGenerator> validGenerators) {
        Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type typeClass = typeArray[n2];
            if (typeClass instanceof TypeVariable) {
                typeClass = ((TypeVariable)typeClass).getBounds()[0];
            }
            if (this.isTypeEqual(typeClass, SqlStatement.class)) {
                return;
            }
            if (((Class)typeClass).isAssignableFrom(statement.getClass()) && generator.supports(statement, database)) {
                validGenerators.add(generator);
            }
            ++n2;
        }
    }

    private SqlGeneratorChain createGeneratorChain(SqlStatement statement, Database database) {
        SortedSet<SqlGenerator> sqlGenerators = this.getGenerators(statement, database);
        if (sqlGenerators == null || sqlGenerators.size() == 0) {
            return null;
        }
        return new SqlGeneratorChain(sqlGenerators);
    }

    public Sql[] generateSql(SqlStatement[] statements, Database database) {
        ArrayList<Sql> returnList = new ArrayList<Sql>();
        SqlStatement[] sqlStatementArray = statements;
        int n = statements.length;
        int n2 = 0;
        while (n2 < n) {
            SqlStatement statement = sqlStatementArray[n2];
            returnList.addAll(Arrays.asList(SqlGeneratorFactory.getInstance().generateSql(statement, database)));
            ++n2;
        }
        return returnList.toArray(new Sql[returnList.size()]);
    }

    public Sql[] generateSql(SqlStatement statement, Database database) {
        SqlGeneratorChain generatorChain = this.createGeneratorChain(statement, database);
        if (generatorChain == null) {
            throw new IllegalStateException("Cannot find generators for database " + database.getClass() + ", statement: " + statement);
        }
        return generatorChain.generateSql(statement, database);
    }

    public boolean generateStatementsVolatile(SqlStatement statement, Database database) {
        for (SqlGenerator generator : this.getGenerators(statement, database)) {
            if (!generator.generateStatementsIsVolatile(database)) continue;
            return true;
        }
        return false;
    }

    public boolean generateRollbackStatementsVolatile(SqlStatement statement, Database database) {
        for (SqlGenerator generator : this.getGenerators(statement, database)) {
            if (!generator.generateRollbackStatementsIsVolatile(database)) continue;
            return true;
        }
        return false;
    }

    public boolean supports(SqlStatement statement, Database database) {
        return this.getGenerators(statement, database).size() > 0;
    }

    public ValidationErrors validate(SqlStatement statement, Database database) {
        SqlGeneratorChain generatorChain = this.createGeneratorChain(statement, database);
        if (generatorChain == null) {
            throw new UnexpectedLiquibaseException("Unable to create generator chain for " + statement.getClass().getName() + " on " + database.getShortName());
        }
        return generatorChain.validate(statement, database);
    }

    public Warnings warn(SqlStatement statement, Database database) {
        return this.createGeneratorChain(statement, database).warn(statement, database);
    }

    public Set<DatabaseObject> getAffectedDatabaseObjects(SqlStatement statement, Database database) {
        Sql[] sqls;
        HashSet<DatabaseObject> affectedObjects = new HashSet<DatabaseObject>();
        SqlGeneratorChain sqlGeneratorChain = this.createGeneratorChain(statement, database);
        if (sqlGeneratorChain != null && (sqls = sqlGeneratorChain.generateSql(statement, database)) != null) {
            Sql[] sqlArray = sqls;
            int n = sqls.length;
            int n2 = 0;
            while (n2 < n) {
                Sql sql = sqlArray[n2];
                affectedObjects.addAll(sql.getAffectedDatabaseObjects());
                ++n2;
            }
        }
        return affectedObjects;
    }
}

