/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.hsqldb.persist.LockFile;

final class NIOLockFile
extends LockFile {
    public static final long MAX_LOCK_REGION = Long.MAX_VALUE;
    public static final long MAX_NFS_LOCK_REGION = 0x40000000L;
    public static final long MIN_LOCK_REGION = 16L;
    public static final boolean POSIX_MANDITORY_FILELOCK_DEFAULT = false;
    public static final String POSIX_MANDITORY_FILELOCK_PROPERTY = "hsqldb.lockfile.posix.manditory.filelock";
    private volatile FileLock fileLock;

    NIOLockFile() {
    }

    public boolean isPosixManditoryFileLock() {
        boolean bl = false;
        try {
            bl = "true".equalsIgnoreCase(System.getProperty(POSIX_MANDITORY_FILELOCK_PROPERTY, bl ? "true" : "false"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    protected boolean doOptionalLockActions() {
        return this.aquireFileLock();
    }

    protected boolean doOptionalReleaseActions() {
        return this.releaseFileLock();
    }

    public boolean isValid() {
        try {
            return super.isValid() && this.fileLock != null && this.fileLock.isValid();
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String toStringImpl() {
        return "fileLock = " + this.fileLock;
    }

    private boolean aquireFileLock() {
        RandomAccessFile randomAccessFile = this.raf;
        boolean bl = false;
        try {
            if (this.fileLock != null) {
                if (this.fileLock.isValid()) {
                    return true;
                }
                this.releaseFileLock();
            }
            if (this.isPosixManditoryFileLock()) {
                try {
                    Runtime.getRuntime().exec(new String[]{"chmod", "g+s,g-x", this.file.getPath()});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.fileLock = randomAccessFile.getChannel().tryLock(0L, 16L, false);
            bl = this.fileLock != null && this.fileLock.isValid();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            this.releaseFileLock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean releaseFileLock() {
        boolean bl = false;
        if (this.fileLock == null) {
            bl = true;
        } else {
            try {
                this.fileLock.release();
                bl = true;
            }
            catch (Exception exception) {
            }
            finally {
                this.fileLock = null;
            }
        }
        return bl;
    }
}

