/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import liquibase.changelog.ChangeSet;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.UtfBomAwareReader;

public class StreamUtil {
    public static final String lineSeparator = System.getProperty("line.separator");

    public static String getLineSeparator() {
        return lineSeparator;
    }

    public static String getStreamContents(InputStream ins) throws IOException {
        return StreamUtil.getReaderContents(new UtfBomAwareReader(ins));
    }

    public static String getStreamContents(InputStream ins, String charsetName) throws IOException {
        UtfBomAwareReader reader;
        if (ins == null) {
            throw new IOException("No stream to open");
        }
        if (charsetName == null) {
            reader = new UtfBomAwareReader(ins);
        } else {
            String charsetCanonicalName = Charset.forName(charsetName).name();
            reader = new UtfBomAwareReader(ins, charsetName);
            String encoding = Charset.forName(reader.getEncoding()).name();
            if (charsetCanonicalName.startsWith("UTF") && !charsetCanonicalName.equals(encoding)) {
                reader.close();
                throw new IllegalArgumentException("Expected encoding was '" + charsetCanonicalName + "' but a BOM was detected for '" + encoding + "'");
            }
        }
        return StreamUtil.getReaderContents(reader);
    }

    public static String getReaderContents(Reader reader) throws IOException {
        try {
            int read;
            StringBuffer result = new StringBuffer();
            char[] buffer = new char[2048];
            while ((read = reader.read(buffer)) > -1) {
                result.append(buffer, 0, read);
            }
            String string = result.toString();
            return string;
        }
        finally {
            StreamUtil.closeQuietly(reader);
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] bytes = new byte[1024];
        int r = inputStream.read(bytes);
        while (r > 0) {
            outputStream.write(bytes, 0, r);
            r = inputStream.read(bytes);
        }
    }

    public static long getContentLength(InputStream in) throws IOException {
        long length = 0L;
        byte[] buf = new byte[4096];
        int bytesRead = in.read(buf);
        while (bytesRead > 0) {
            length += (long)bytesRead;
            bytesRead = in.read(buf);
        }
        return length;
    }

    public static long getContentLength(Reader reader) throws IOException {
        long length = 0L;
        char[] buf = new char[2048];
        int charsRead = reader.read(buf);
        while (charsRead > 0) {
            length += (long)charsRead;
            charsRead = reader.read(buf);
        }
        return length;
    }

    public static void closeQuietly(Reader input) {
        StreamUtil.closeQuietly((Closeable)input);
    }

    public static void closeQuietly(InputStream input) {
        StreamUtil.closeQuietly((Closeable)input);
    }

    public static void closeQuietly(Closeable input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static InputStream openStream(String path, Boolean relativeToChangelogFile, ChangeSet changeSet, ResourceAccessor resourceAccessor) throws IOException {
        InputStream stream = StreamUtil.openFromClasspath(path, relativeToChangelogFile, changeSet, resourceAccessor);
        if (stream == null) {
            stream = StreamUtil.openFromFileSystem(path, relativeToChangelogFile, changeSet, resourceAccessor);
        }
        return stream;
    }

    private static InputStream openFromFileSystem(String file, Boolean relativeToChangelogFile, ChangeSet changeSet, ResourceAccessor resourceAccessor) throws IOException {
        if (resourceAccessor == null) {
            return null;
        }
        if (relativeToChangelogFile != null && relativeToChangelogFile.booleanValue()) {
            String base = changeSet.getChangeLog() == null ? changeSet.getFilePath() : changeSet.getChangeLog().getPhysicalFilePath().replaceAll("\\\\", "/");
            if (!base.contains("/")) {
                base = ".";
            }
            file = String.valueOf(base.replaceFirst("/[^/]*$", "")) + "/" + file;
        }
        return resourceAccessor.getResourceAsStream(file);
    }

    private static InputStream openFromClasspath(String file, Boolean relativeToChangelogFile, ChangeSet changeSet, ResourceAccessor resourceAccessor) throws IOException {
        if (resourceAccessor == null) {
            return null;
        }
        if (relativeToChangelogFile != null && relativeToChangelogFile.booleanValue()) {
            String base = changeSet.getChangeLog() == null ? changeSet.getFilePath() : changeSet.getChangeLog().getPhysicalFilePath().replaceAll("\\\\", "/");
            if (!base.contains("/")) {
                base = ".";
            }
            file = String.valueOf(base.replaceFirst("/[^/]*$", "")) + "/" + file;
        }
        return resourceAccessor.getResourceAsStream(file);
    }
}

