/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.odt.writer;

import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.emitter.odt.IOdtWriter;
import org.eclipse.birt.report.engine.emitter.odt.OdtEmitter;
import org.eclipse.birt.report.engine.emitter.odt.TocInfo;
import org.eclipse.birt.report.engine.odf.DiagonalLineInfo;
import org.eclipse.birt.report.engine.odf.OdfUtil;
import org.eclipse.birt.report.engine.odf.style.HyperlinkInfo;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.engine.odf.writer.AbstractOdfWriter;

public class BodyWriter
extends AbstractOdfWriter
implements IOdtWriter {
    public static final Logger logger = Logger.getLogger(BodyWriter.class.getName());
    protected final String RIGHT = "right";
    protected final String LEFT = "left";
    protected final String TOP = "top";
    protected final String BOTTOM = "bottom";
    protected boolean rtl = false;

    public BodyWriter(OutputStream out) throws Exception {
        this(out, "UTF-8");
    }

    public BodyWriter(OutputStream out, String encoding) throws Exception {
        this.writer = new XMLWriter();
        this.writer.setIndent(false);
        this.writer.open(out, encoding);
    }

    @Override
    public void start(boolean rtl) {
        this.rtl = rtl;
        this.writer.openTag("office:body");
        this.writer.openTag("office:text");
    }

    @Override
    public void drawImage(String imageUrl, double height, double width, HyperlinkInfo hyper, StyleEntry style, StyleEntry pStyle, OdtEmitter.InlineFlag inlineFlag, String altText, String bookmark, TocInfo tocInfo) {
        if (inlineFlag == OdtEmitter.InlineFlag.BLOCK || inlineFlag == OdtEmitter.InlineFlag.FIRST_INLINE) {
            this.writer.openTag("text:p");
            if (pStyle != null) {
                this.writer.attribute("text:style-name", pStyle.getName());
            }
        }
        this.writeBookmark(bookmark);
        this.writeTOC(tocInfo);
        int imageId = this.getImageID();
        this.openHyperlink(hyper, "draw");
        this.drawImage(imageUrl, null, null, null, height, width, style, altText, null, imageId);
        this.closeHyperlink(hyper, "draw");
        if (inlineFlag == OdtEmitter.InlineFlag.BLOCK) {
            this.writer.closeTag("text:p");
        }
    }

    @Override
    public void writeContent(int type, String txt, StyleEntry style, StyleEntry inlineStyle, String fontFamily, HyperlinkInfo info, OdtEmitter.InlineFlag inlineFlag, OdtEmitter.TextFlag flag, int paragraphWidth, boolean runIsRtl, List<String> bookmark, List<TocInfo> tocs) {
        if (inlineFlag == OdtEmitter.InlineFlag.BLOCK) {
            this.writeText(type, txt, style, fontFamily, info, flag, paragraphWidth, runIsRtl, bookmark, tocs);
        } else {
            boolean isInline = true;
            if (inlineFlag == OdtEmitter.InlineFlag.FIRST_INLINE && flag == OdtEmitter.TextFlag.START) {
                this.startParagraph(style, isInline, paragraphWidth, bookmark, tocs);
            }
            if (inlineStyle != null) {
                this.writeTextInRun(type, txt, inlineStyle, fontFamily, info, isInline, paragraphWidth, runIsRtl);
            } else {
                this.writeTextInRun(type, txt, style, fontFamily, info, isInline, paragraphWidth, runIsRtl);
            }
        }
    }

    @Override
    public void startPage() {
    }

    @Override
    public void endPage() {
    }

    @Override
    public void end() {
        this.writer.closeTag("office:text");
        this.writer.closeTag("office:body");
        try {
            this.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    @Override
    public void writeTOC(TocInfo tocInfo) {
        if (tocInfo == null || "".equals(tocInfo.tocValue)) {
            return;
        }
        this.writer.openTag("text:bookmark");
        this.writer.attribute("text:name", "_Toc" + tocInfo.tocValue);
        this.writer.closeTag("text:bookmark");
        ++this.bookmarkId;
        this.writer.openTag("text:toc-mark");
        this.writer.attribute("text:string-value", tocInfo.tocValue);
        this.writer.attribute("text:outline-level", tocInfo.tocLevel);
        this.writer.closeTag("text:toc-mark");
    }

    @Override
    public void writeForeign(IForeignContent foreignContent) {
    }

    private boolean needNewParagraph(String txt) {
        return "\n".equals(txt) || "\r".equalsIgnoreCase(txt) || "\r\n".equals(txt);
    }

    public void startParagraph(StyleEntry style, boolean isInline, int paragraphWidth, List<String> bookmarks, List<TocInfo> tocs) {
        this.writer.openTag("text:p");
        if (style != null && style.getType() == 0) {
            this.writer.attribute("text:style-name", style.getName());
        }
        this.writeTocs(tocs);
        this.writeBookmarks(bookmarks);
    }

    private void writeBookmarks(List<String> bookmarks) {
        if (bookmarks != null) {
            for (String bookmark : bookmarks) {
                this.writeBookmark(bookmark);
            }
            bookmarks.clear();
        }
    }

    @Override
    public void endParagraph() {
        this.writer.closeTag("text:p");
    }

    @Override
    public void writeCaption(String txt, StyleEntry style) {
        this.writer.openTag("text:p");
        if (style != null) {
            this.writer.attribute("text:style-name", style.getName());
        }
        this.writeString(txt);
        this.writer.closeTag("text:p");
    }

    private void writeTextInParagraph(int type, String txt, StyleEntry style, String fontFamily, HyperlinkInfo info, int paragraphWidth, boolean runIsRtl, List<String> bookmarks, List<TocInfo> tocs) {
        this.writer.openTag("text:p");
        if (style != null) {
            this.writer.attribute("text:style-name", style.getName());
        }
        this.writeBookmarks(bookmarks);
        this.writeTocs(tocs);
        this.writeTextInRun(type, txt, style, fontFamily, info, false, paragraphWidth, runIsRtl);
    }

    public void writeText(int type, String txt, StyleEntry style, String fontFamily, HyperlinkInfo info, OdtEmitter.TextFlag flag, int paragraphWidth, boolean runIsRtl, List<String> bookmark, List<TocInfo> tocs) {
        if (flag == OdtEmitter.TextFlag.START) {
            this.writeTextInParagraph(type, txt, style, fontFamily, info, paragraphWidth, runIsRtl, bookmark, tocs);
        } else if (flag == OdtEmitter.TextFlag.END) {
            this.writer.closeTag("text:p");
        } else if (flag == OdtEmitter.TextFlag.MIDDLE) {
            this.writeTextInRun(type, txt, style, fontFamily, info, false, paragraphWidth, runIsRtl);
        } else {
            this.writeTextInParagraph(type, txt, style, fontFamily, info, paragraphWidth, runIsRtl, bookmark, tocs);
            this.writer.closeTag("text:p");
        }
    }

    public void writeTextInRun(int type, String txt, StyleEntry style, String fontFamily, HyperlinkInfo info, boolean isInline, int paragraphWidth, boolean runIsRtl) {
        if ("".equals(txt)) {
            return;
        }
        if (this.needNewParagraph(txt)) {
            this.writer.closeTag("text:p");
            this.startParagraph(style, isInline, paragraphWidth, null, null);
            return;
        }
        this.openHyperlink(info);
        boolean isField = OdfUtil.isField(type);
        this.writeSpan(txt, style, info, type, isField);
        this.closeHyperlink(info);
    }

    @Override
    public void drawDiagonalLine(DiagonalLineInfo diagonalLineInfo) {
        if (diagonalLineInfo.getDiagonalNumber() <= 0 && diagonalLineInfo.getAntiDiagonalNumber() <= 0) {
            return;
        }
        this.writer.openTag("text:p");
        this.writer.attribute("text:style-name", "Hidden");
        this.writer.closeTag("text:p");
    }

    @Override
    public void writeMarkersParagraph(List<String> bookmarks, List<TocInfo> tableTocs) {
        if (!bookmarks.isEmpty() || !tableTocs.isEmpty()) {
            this.writer.openTag("text:p");
            this.writeBookmarks(bookmarks);
            this.writeTocs(tableTocs);
            tableTocs.clear();
            this.writer.closeTag("text:p");
            bookmarks.clear();
        }
    }

    @Override
    public void writeTableToc(List<TocInfo> tableTocs) {
        if (!tableTocs.isEmpty()) {
            this.writeTocs(tableTocs);
            tableTocs.clear();
        }
    }

    private void writeTocs(List<TocInfo> tableTocs) {
        if (tableTocs != null) {
            for (TocInfo toc : tableTocs) {
                this.writeTOC(toc);
            }
            tableTocs.clear();
        }
    }

    @Override
    protected void closeHyperlink(HyperlinkInfo info, String baseType) {
        if (info == null || info.getType() == 2) {
            return;
        }
        this.writer.closeTag(String.valueOf(baseType) + ":a");
    }
}

