/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import com.ibm.icu.util.ULocale;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.birt.report.model.core.CachedBundles;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ResourceHelper;

public class BundleHelper
extends ResourceHelper {
    private Module module = null;

    private BundleHelper(Module module, String baseName) {
        super(baseName);
        this.module = module;
    }

    public static BundleHelper getHelper(Module module, String baseName) {
        assert (module != null);
        return new BundleHelper(module, baseName);
    }

    public Collection getMessageKeys(ULocale locale) {
        CachedBundles moduleBundle = this.module.getResourceBundle();
        if (moduleBundle == null) {
            moduleBundle = new CachedBundles();
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        List<String> bundleNames = this.getMessageFilenames(locale);
        int i = 0;
        while (i < bundleNames.size()) {
            String tmpName = bundleNames.get(i);
            if (!moduleBundle.isCached(tmpName)) {
                moduleBundle.addCachedBundle(tmpName, this.findBundle(tmpName));
            }
            keys.addAll(moduleBundle.getMessageKeys(tmpName));
            ++i;
        }
        return keys;
    }

    public String getMessage(String resourceKey, ULocale locale) {
        CachedBundles moduleBundle = this.module.getResourceBundle();
        if (moduleBundle == null) {
            moduleBundle = new CachedBundles();
        }
        List<String> bundleNames = this.getMessageFilenames(locale);
        int i = 0;
        while (i < bundleNames.size()) {
            String translation;
            String tmpName = bundleNames.get(i);
            if (!moduleBundle.isCached(tmpName)) {
                moduleBundle.addCachedBundle(tmpName, this.findBundle(tmpName));
            }
            if ((translation = moduleBundle.getMessage(tmpName, resourceKey)) != null) {
                return translation;
            }
            ++i;
        }
        return null;
    }

    private URL findBundle(String fileName) {
        assert (fileName != null);
        return this.module.findResource(fileName, 0);
    }
}

