/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.jar;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.ResourceBundle;
import org.eclipse.birt.core.framework.jar.Bundle;
import org.eclipse.birt.core.framework.jar.Extension;
import org.eclipse.birt.core.framework.jar.ExtensionPoint;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IRegistryEventListener;

public class ExtensionRegistry
implements IExtensionRegistry {
    protected HashMap<String, Bundle> bundles = new HashMap();
    protected HashMap<String, ExtensionPoint> extensionPoints = new HashMap();
    protected HashMap<String, Extension> extensions = new HashMap();

    ExtensionRegistry() {
    }

    public void addBundle(Bundle bundle) {
        ExtensionPoint[] points;
        Extension[] extensions;
        this.bundles.put(bundle.getSymbolicName(), bundle);
        Extension[] extensionArray = extensions = bundle.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            Extension extension = extensionArray[n2];
            this.extensions.put(extension.getUniqueIdentifier(), extension);
            ++n2;
        }
        ExtensionPoint[] extensionPointArray = points = bundle.getExtensionPoints();
        int n3 = points.length;
        n = 0;
        while (n < n3) {
            ExtensionPoint point = extensionPointArray[n];
            this.extensionPoints.put(point.getUniqueIdentifier(), point);
            ++n;
        }
    }

    public IConfigurationElement[] getConfigurationElementsFor(String extensionId) {
        IExtension extension = this.getExtension(extensionId);
        if (extension != null) {
            return extension.getConfigurationElements();
        }
        return null;
    }

    public IExtension getExtension(String extensionId) {
        return this.extensions.get(extensionId);
    }

    public IExtension getExtension(String extensionPointId, String extensionId) {
        IExtension extension = this.getExtension(extensionId);
        if (extension != null && extension.getExtensionPointUniqueIdentifier().equals(extensionPointId)) {
            return extension;
        }
        return null;
    }

    public IExtension[] getExtensions(String extensionPointId) {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (Bundle bundle : this.bundles.values()) {
            Extension[] bundleExtensions;
            Extension[] extensionArray = bundleExtensions = bundle.getExtensions();
            int n = bundleExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                Extension extension = extensionArray[n2];
                String extPointId = extension.getExtensionPointUniqueIdentifier();
                if (extPointId.equals(extensionPointId)) {
                    extensions.add(extension);
                }
                ++n2;
            }
        }
        return extensions.toArray(new IExtension[extensions.size()]);
    }

    public IExtensionPoint getExtensionPoint(String extensionPointId) {
        return this.extensionPoints.get(extensionPointId);
    }

    public IExtensionPoint[] getExtensionPoints() {
        return this.extensionPoints.values().toArray(new IExtensionPoint[this.extensionPoints.size()]);
    }

    public boolean addContribution(InputStream is, IContributor contributor, boolean persist, String name, ResourceBundle translationBundle, Object token) throws IllegalArgumentException {
        throw new UnsupportedOperationException("addContribution is not implemented yet");
    }

    public void addListener(IRegistryEventListener listener) {
        throw new UnsupportedOperationException("addListener is not implemented yet");
    }

    public void addListener(IRegistryEventListener listener, String extensionPointId) {
        throw new UnsupportedOperationException("addListener is not implemented yet");
    }

    public void addRegistryChangeListener(IRegistryChangeListener arg0) {
        throw new UnsupportedOperationException("addRegistryChangeListener is not implemented yet");
    }

    public void addRegistryChangeListener(IRegistryChangeListener listener, String token) {
        throw new UnsupportedOperationException("addRegistryChangeListener is not implemented yet");
    }

    public IConfigurationElement[] getConfigurationElementsFor(String namespace, String extensionPointName) {
        IExtensionPoint extPoint = this.getExtensionPoint(namespace, extensionPointName);
        if (extPoint == null) {
            return new IConfigurationElement[0];
        }
        return extPoint.getConfigurationElements();
    }

    public IConfigurationElement[] getConfigurationElementsFor(String namespace, String extensionPointName, String extensionId) {
        IExtension extension = this.getExtension(namespace, extensionPointName, extensionId);
        if (extension == null) {
            return new IConfigurationElement[0];
        }
        return extension.getConfigurationElements();
    }

    public IExtension getExtension(String namespace, String extensionPointName, String extensionId) {
        IExtensionPoint point = this.getExtensionPoint(namespace, extensionPointName);
        if (point != null) {
            return point.getExtension(extensionId);
        }
        return null;
    }

    public IExtensionPoint getExtensionPoint(String namespace, String name) {
        IExtensionPoint[] points;
        IExtensionPoint[] iExtensionPointArray = points = this.getExtensionPoints(namespace);
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionPoint point = iExtensionPointArray[n2];
            if (name.equals(point.getSimpleIdentifier())) {
                return point;
            }
            ++n2;
        }
        return null;
    }

    public IExtensionPoint[] getExtensionPoints(String namespace) {
        ArrayList<IExtensionPoint> extPoints = new ArrayList<IExtensionPoint>();
        Collection<ExtensionPoint> allExtPoints = this.extensionPoints.values();
        for (IExtensionPoint iExtensionPoint : allExtPoints) {
            if (!namespace.equals(iExtensionPoint.getNamespace())) continue;
            extPoints.add(iExtensionPoint);
        }
        return extPoints.toArray(new IExtensionPoint[extPoints.size()]);
    }

    public IExtensionPoint[] getExtensionPoints(IContributor contributor) {
        for (Bundle bundle : this.bundles.values()) {
            if (bundle.getContributor() != contributor) continue;
            return bundle.getExtensionPoints();
        }
        return new IExtensionPoint[0];
    }

    public IExtension[] getExtensions(IContributor contributor) {
        for (Bundle bundle : this.bundles.values()) {
            if (bundle.getContributor() != contributor) continue;
            return bundle.getExtensions();
        }
        return new IExtension[0];
    }

    public String[] getNamespaces() {
        return this.bundles.keySet().toArray(new String[this.bundles.size()]);
    }

    public boolean isMultiLanguage() {
        return false;
    }

    public boolean removeExtension(IExtension extension, Object token) throws IllegalArgumentException {
        throw new UnsupportedOperationException("removeExtension is not implemented yet");
    }

    public boolean removeExtensionPoint(IExtensionPoint extensionPoint, Object token) throws IllegalArgumentException {
        throw new UnsupportedOperationException("removeExtensionPoint is not implemented yet");
    }

    public void removeListener(IRegistryEventListener listener) {
        throw new UnsupportedOperationException("removeListener is not implemented yet");
    }

    public void removeRegistryChangeListener(IRegistryChangeListener listener) {
        throw new UnsupportedOperationException("removeRegistryChangeListener is not implemented yet");
    }

    public void stop(Object token) throws IllegalArgumentException {
        throw new UnsupportedOperationException("stop is not implemented yet");
    }
}

