/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.pupitri;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.pupitri.PupitriSpeciesContext;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableFloat;

public class CarrouselImportRequestResult {
    private final ListMultimap<String, Species> speciesByCode;
    private int nbCarrousselImported;
    private MutableFloat carrouselSortedWeight;
    private MutableFloat carrouselUnsortedWeight;
    private final Set<String> notImportedSpeciesIds;
    private final List<PupitriSpeciesContext> catches;

    public CarrouselImportRequestResult(ListMultimap<String, Species> speciesByCode) {
        this.speciesByCode = speciesByCode;
        this.notImportedSpeciesIds = new LinkedHashSet<String>();
        this.catches = Lists.newArrayList();
    }

    public void incrementNbCarrousselImported() {
        ++this.nbCarrousselImported;
    }

    public void addCarrouselSortedWeight(Float beanWeight) {
        if (this.carrouselSortedWeight == null) {
            this.carrouselSortedWeight = new MutableFloat();
        }
        if (beanWeight != null) {
            this.carrouselSortedWeight.add((Number)beanWeight);
        }
    }

    public void addCarrouselUnsortedWeight(Float beanWeight) {
        if (this.carrouselUnsortedWeight == null) {
            this.carrouselUnsortedWeight = new MutableFloat();
        }
        if (beanWeight != null) {
            this.carrouselUnsortedWeight.add((Number)beanWeight);
        }
    }

    public List<Species> getSpecies(String speciesId) {
        return this.speciesByCode.get((Object)speciesId);
    }

    public void addNotImportedSpeciesId(String speciesId) {
        this.notImportedSpeciesIds.add(speciesId);
    }

    public PupitriSpeciesContext getOrCreateCatch(List<Species> speciesList, boolean sorted) {
        Species species = speciesList.get(0);
        PupitriSpeciesContext pupitriSpeciesContext = new PupitriSpeciesContext(species, sorted);
        int catchIndex = this.catches.indexOf(pupitriSpeciesContext);
        if (catchIndex >= 0) {
            pupitriSpeciesContext = this.catches.get(catchIndex);
        } else {
            this.catches.add(pupitriSpeciesContext);
        }
        return pupitriSpeciesContext;
    }

    public float getCarrouselSortedWeight() {
        return this.carrouselSortedWeight == null ? 0.0f : this.carrouselSortedWeight.floatValue();
    }

    public float getCarrouselUnsortedWeight() {
        return this.carrouselUnsortedWeight == null ? 0.0f : this.carrouselUnsortedWeight.floatValue();
    }

    public int getNbCarrousselImported() {
        return this.nbCarrousselImported;
    }

    public Set<String> getNotImportedSpeciesIds() {
        return this.notImportedSpeciesIds;
    }

    public List<PupitriSpeciesContext> getCatches() {
        return this.catches;
    }
}

