/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.dao;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.dao.DaoFactory;
import fr.ifremer.adagio.synchro.dao.DaoStats;
import fr.ifremer.adagio.synchro.dao.SynchroBaseDao;
import fr.ifremer.adagio.synchro.dao.SynchroBaseDaoImpl;
import fr.ifremer.adagio.synchro.dao.SynchroTableDao;
import fr.ifremer.adagio.synchro.dao.SynchroTableDaoImpl;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.service.SynchroDatabaseConfiguration;
import fr.ifremer.adagio.synchro.service.SynchroTableOperation;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DaoFactoryImpl
implements DaoFactory {
    private static final Log log = LogFactory.getLog(DaoFactoryImpl.class);
    private SynchroDatabaseMetadata dbMeta;
    private SynchroDatabaseConfiguration dbConfig;
    private Connection connection;
    private final LoadingCache<SynchroTableMetadata, SynchroTableDao> daoCache;
    private final SynchroBaseDao sharedBaseDao;
    private final DaoStats stats;

    public DaoFactoryImpl(SynchroDatabaseMetadata dbMeta) throws SQLException {
        this(dbMeta.getConnection(), dbMeta.getConfiguration(), dbMeta, 50, 50);
    }

    public DaoFactoryImpl(SynchroDatabaseMetadata dbMeta, int daoCacheSize, int statementCacheSize) throws SQLException {
        this(dbMeta.getConnection(), dbMeta.getConfiguration(), dbMeta, daoCacheSize, statementCacheSize);
    }

    public DaoFactoryImpl(Connection connection, SynchroDatabaseConfiguration dbConfig, SynchroDatabaseMetadata dbMeta, int daoCacheSize, int statementCacheSize) {
        int validStatementCacheSize;
        Preconditions.checkNotNull((Object)dbMeta);
        Preconditions.checkNotNull((Object)dbConfig);
        Preconditions.checkNotNull((Object)connection);
        this.dbMeta = dbMeta;
        this.dbConfig = dbConfig;
        this.connection = connection;
        this.stats = new DaoStats();
        int validDaoCacheSize = daoCacheSize > 0 ? daoCacheSize : 50;
        int n = validStatementCacheSize = statementCacheSize > 0 ? statementCacheSize : 50;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Intializing a DaoFactory with [dao cache size: %s] and [statement cache size: %s]", validDaoCacheSize, validStatementCacheSize));
        }
        this.daoCache = this.initDaoCache(validDaoCacheSize, 300);
        this.sharedBaseDao = new SynchroBaseDaoImpl(connection, dbConfig, dbMeta, this, this.stats, validStatementCacheSize, 300, 1000, 60);
    }

    @Override
    public SynchroTableDao getSourceDao(SynchroTableMetadata table) {
        Preconditions.checkNotNull((Object)table);
        try {
            SynchroTableDao dao = (SynchroTableDao)this.daoCache.get((Object)table);
            dao.setSourceDao(null);
            dao.setCurrentOperation(null);
            dao.prepare();
            return dao;
        }
        catch (ExecutionException e) {
            throw new SynchroTechnicalException(String.format("[%s] Error during dao loading (using cache): %s", table.getName(), e.getMessage()), e);
        }
    }

    @Override
    public SynchroTableDao getTargetDao(SynchroTableMetadata table, SynchroTableDao sourceDao, SynchroTableOperation currentOperation) {
        SynchroTableDao targetDao = this.getSourceDao(table);
        targetDao.setSourceDao(sourceDao);
        targetDao.setCurrentOperation(currentOperation);
        return targetDao;
    }

    @Override
    public SynchroTableDao getSourceDao(String tableName) {
        SynchroTableMetadata table = this.dbMeta.getTable(tableName);
        return this.getSourceDao(table);
    }

    public SynchroTableDao getTargetDao(String tableName, SynchroTableDao sourceDao, SynchroTableOperation currentOperation) {
        SynchroTableDao targetDao = this.getSourceDao(tableName);
        targetDao.setSourceDao(sourceDao);
        targetDao.setCurrentOperation(currentOperation);
        return targetDao;
    }

    @Override
    public SynchroBaseDao getDao() {
        return this.sharedBaseDao;
    }

    protected LoadingCache<SynchroTableMetadata, SynchroTableDao> initDaoCache(int maximumSize, int durationInSeconds) {
        return CacheBuilder.newBuilder().maximumSize((long)maximumSize).expireAfterAccess((long)durationInSeconds, TimeUnit.SECONDS).removalListener((RemovalListener)new RemovalListener<SynchroTableMetadata, SynchroTableDao>(){

            public void onRemoval(RemovalNotification<SynchroTableMetadata, SynchroTableDao> notification) {
                IOUtils.closeQuietly((Closeable)((Closeable)notification.getValue()));
            }
        }).build((CacheLoader)new CacheLoader<SynchroTableMetadata, SynchroTableDao>(){

            public SynchroTableDao load(SynchroTableMetadata table) throws SQLException {
                return DaoFactoryImpl.this.newSynchroTableDao(table);
            }
        });
    }

    protected SynchroTableDao newSynchroTableDao(SynchroTableMetadata table) throws SQLException {
        this.stats.incrementDao();
        return new SynchroTableDaoImpl(this.connection, this.dbConfig, table, this.sharedBaseDao);
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Closeable)this.sharedBaseDao);
        this.daoCache.invalidateAll();
        if (log.isDebugEnabled()) {
            log.debug((Object)this.stats.toString());
        }
        this.dbMeta = null;
        this.dbConfig = null;
        this.connection = null;
    }
}

