/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.birt.report.model.util.XMLWriter;

public class IndentableXMLWriter
extends XMLWriter {
    protected static final int MAX_CHARS_PER_LINE = 80;
    public static final String LINE_SEPARATOR = "\n";
    protected static final String TAB = "    ";
    protected ArrayList<String> cachedIndents = new ArrayList();
    private String lastTagName = null;

    public IndentableXMLWriter(File outputFile, String signature) throws IOException {
        super(outputFile, signature);
    }

    public IndentableXMLWriter(File outputFile, String signature, boolean needMarkLineNumber) throws IOException {
        super(outputFile, signature, needMarkLineNumber);
    }

    public IndentableXMLWriter(OutputStream os, String signature) throws IOException {
        super(os, signature);
    }

    public IndentableXMLWriter(OutputStream os, String signature, boolean needMarkLineNumber) throws IOException {
        super(os, signature, needMarkLineNumber);
    }

    protected IndentableXMLWriter() {
    }

    @Override
    protected void emitStartTag(String tagName) {
        this.lastTagName = tagName;
        this.literal(this.getIndent(this.elementStack.size()));
        super.emitStartTag(tagName);
    }

    @Override
    public void endElement() {
        String tagName = "";
        if (!this.elementStack.isEmpty()) {
            tagName = (String)this.elementStack.peek();
        }
        if (!(this.elementStack.isEmpty() || tagName.equalsIgnoreCase(this.lastTagName) || !this.pendingElementStack.isEmpty() && (this.pendingElementStack.isEmpty() || tagName.equals(this.pendingElementStack.peek())))) {
            this.literal(this.getIndent(this.elementStack.size() - 1));
        }
        this.lastTagName = tagName;
        super.endElement();
    }

    private String getIndent(int level) {
        String indent = "";
        if (this.cachedIndents.size() == 0) {
            this.cachedIndents.add(indent);
        } else if (this.cachedIndents.size() <= level) {
            indent = this.cachedIndents.get(this.cachedIndents.size() - 1);
            indent = String.valueOf(indent) + TAB;
            this.cachedIndents.add(indent);
        } else {
            indent = this.cachedIndents.get(level);
        }
        return indent;
    }

    private String getCurElementIndent() {
        if (this.cachedIndents.size() == 0) {
            return "";
        }
        String indent = this.cachedIndents.get(this.elementStack.size() - 1);
        return indent;
    }

    @Override
    public void indentLongText(String text) {
        assert (text != null);
        assert (text.length() >= 80);
        this.closeTextTag();
        String curTabs = this.getCurElementIndent().concat(TAB);
        this.literal(LINE_SEPARATOR + curTabs);
        int len = text.length();
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c == '&') {
                this.literal("&amp;");
            } else if (c == '<') {
                this.literal("&lt;");
            } else {
                this.literal(Character.toString(c));
            }
            if (i + 1 != len && (i + 1) % 80 == 0) {
                this.literal(LINE_SEPARATOR + curTabs);
            }
            ++i;
        }
        this.literal(LINE_SEPARATOR + this.getCurElementIndent());
    }

    @Override
    public void writeBase64Text(String text) {
        assert (text != null);
        this.closeTextTag();
        if (!this.markLineNumber) {
            this.out.print(text);
            return;
        }
        this.printLine();
        String tabs = this.getCurElementIndent().concat(TAB);
        int length = text.length();
        int lineStart = 0;
        while (lineStart < length) {
            int lineEnd = lineStart + 80;
            if (lineEnd > length) {
                lineEnd = length;
            }
            this.out.print(tabs);
            this.out.print(text.substring(lineStart, lineEnd));
            this.printLine();
            lineStart = lineEnd;
        }
    }
}

