/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.service.export.pdf.CatchesPdfExportService;
import fr.ifremer.tutti.ui.swing.action.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.io.File;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class SendCruiseReportAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(SendCruiseReportAction.class);
    protected File file;

    public SendCruiseReportAction(MainUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            Cruise cruise = this.getDataContext().getCruise();
            this.file = this.saveFile("exportCruise-" + cruise.getName(), "pdf", I18n.t((String)"tutti.sendCruiseReport.title.choose.exportFile", (Object[])new Object[0]), I18n.t((String)"tutti.sendCruiseReport.action.chooseFile", (Object[])new Object[0]), new String[]{"^.+\\.pdf$", I18n.t((String)"tutti.common.file.pdf", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Cruise cruise = this.getDataContext().getCruise();
        Preconditions.checkNotNull((Object)cruise);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export cruise " + cruise.getId() + " to file: " + this.file));
        }
        CatchesPdfExportService service = this.getContext().getGeneratePDFService();
        service.generateCruisePDFFile(this.file, cruise.getId(), this.getConfig().getI18nLocale());
        try {
            TuttiUIUtil.mail((String)I18n.t((String)"tutti.sendCruiseReport.mail.subject", (Object[])new Object[]{cruise.getName()}), (String)I18n.t((String)"tutti.sendCruiseReport.mail.body", (Object[])new Object[]{cruise.getName(), this.file.getAbsolutePath()}));
        }
        catch (ApplicationTechnicalException e) {
            JOptionPane.showMessageDialog(this.getContext().getMainUI(), I18n.t((String)"tutti.sendCruiseReport.action.error.mail.message", (Object[])new Object[]{this.file}), I18n.t((String)"tutti.sendCruiseReport.action.error.mail.title", (Object[])new Object[0]), 2);
        }
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.sendCruiseReport.action.success", (Object[])new Object[]{this.file}));
    }
}

