/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.referential;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import fr.ifremer.tutti.persistence.entities.referential.AbstractVessels;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntities;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;

public class Vessels
extends AbstractVessels {
    public static final Predicate<Vessel> IS_TEMPORARY = new Predicate<Vessel>(){

        public boolean apply(Vessel input) {
            return Vessels.isTemporary(input);
        }
    };
    public static final Function<Vessel, String> GET_INTERNAL_REGISTRATION_CODE = new Function<Vessel, String>(){

        public String apply(Vessel input) {
            return input.getInternationalRegistrationCode();
        }
    };

    public static boolean isTemporary(Vessel vessel) {
        Preconditions.checkNotNull((Object)vessel);
        Preconditions.checkNotNull((Object)vessel.getId());
        return TuttiReferentialEntities.isStatusTemporary(vessel) && vessel.getId().startsWith("#TEMP\u00bf");
    }
}

