/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog.filter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.exception.RollbackFailedException;

public class AfterTagChangeSetFilter
implements ChangeSetFilter {
    private Set<String> changeLogsAfterTag = new HashSet<String>();

    public AfterTagChangeSetFilter(String tag, List<RanChangeSet> ranChangeSets) throws RollbackFailedException {
        boolean seenTag = false;
        for (RanChangeSet ranChangeSet : ranChangeSets) {
            if (seenTag && !tag.equalsIgnoreCase(ranChangeSet.getTag())) {
                this.changeLogsAfterTag.add(this.changeLogToString(ranChangeSet.getId(), ranChangeSet.getAuthor(), ranChangeSet.getChangeLog()));
            }
            if (seenTag || !tag.equalsIgnoreCase(ranChangeSet.getTag())) continue;
            seenTag = true;
        }
        if (!seenTag) {
            throw new RollbackFailedException("Could not find tag '" + tag + "' in the database");
        }
    }

    private String changeLogToString(String id, String author, String changeLog) {
        return String.valueOf(id) + ":" + author + ":" + changeLog;
    }

    @Override
    public boolean accepts(ChangeSet changeSet) {
        return this.changeLogsAfterTag.contains(this.changeLogToString(changeSet.getId(), changeSet.getAuthor(), changeSet.getFilePath()));
    }
}

