/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.DataSourceRuntime;

class DataSourceManager {
    private List dataSourceRuntimeList = new ArrayList();
    private Logger logger;

    DataSourceManager(Logger logger) {
        this.logger = logger;
    }

    void addDataSource(DataSourceRuntime dataSourceRuntime) throws DataException {
        if (dataSourceRuntime.canClose()) {
            this.closeDataSource(dataSourceRuntime);
        } else {
            this.close(false);
        }
        this.dataSourceRuntimeList.add(dataSourceRuntime);
    }

    void close() {
        this.close(true);
    }

    private void close(boolean forceClose) {
        for (DataSourceRuntime ds : this.dataSourceRuntimeList) {
            try {
                if (!forceClose && !ds.canClose()) continue;
                this.closeDataSource(ds);
            }
            catch (DataException e) {
                if (!this.logger.isLoggable(Level.FINE)) continue;
                this.logger.log(Level.FINE, "The data source (" + ds + ") fails to shut down", e);
            }
        }
    }

    private void closeDataSource(DataSourceRuntime ds) throws DataException {
        if (ds.isOpen()) {
            ds.beforeClose();
            ds.closeOdiDataSource();
            ds.afterClose();
        }
    }
}

