/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import fr.ifremer.tutti.ui.swing.action.AbstractChangeScreenAction;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.action.ApplicationActionException;
import org.nuiton.jaxx.application.swing.util.ApplicationErrorHelper;
import org.nuiton.jaxx.application.swing.util.ApplicationExceptionHandler;

public class TuttiExceptionHandler
extends ApplicationExceptionHandler {
    private static final Log log = LogFactory.getLog(TuttiExceptionHandler.class);

    public TuttiExceptionHandler(ApplicationErrorHelper errorHelper) {
        super(errorHelper);
    }

    protected void handleException(String tname, Throwable ex) {
        if (log.isErrorEnabled()) {
            log.error((Object)("Global application exception [" + tname + "]"), ex);
        }
        Throwable cause = this.getCause(ex);
        boolean backToScreen = false;
        AbstractTuttiAction action = null;
        if (cause instanceof ApplicationActionException) {
            ApplicationActionException actionException = (ApplicationActionException)cause;
            cause = cause.getCause();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Action error cause:", cause);
            }
            if ((action = (AbstractTuttiAction)actionException.getAction()) instanceof AbstractChangeScreenAction) {
                backToScreen = true;
            }
        }
        this.showErrorDialog(cause.getMessage(), cause);
        if (backToScreen) {
            action.getContext().setFallBackScreen();
        }
    }
}

