/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import fr.ifremer.tutti.ui.swing.action.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import org.nuiton.i18n.I18n;

public class CloseDbAction
extends AbstractMainUITuttiAction {
    protected String jdbcUrl;

    public CloseDbAction(MainUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean canContinue = super.prepareAction();
        if (canContinue) {
            this.jdbcUrl = this.getConfig().getJdbcUrl();
        }
        return canContinue;
    }

    @Override
    public void doAction() {
        this.getContext().getPersistenceService().clearAllCaches();
        this.getContext().setDbLoaded(false);
        this.getContext().reloadPersistenceService();
        this.getContext().clearDbContext();
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.flash.info.db.closed", (Object[])new Object[]{this.jdbcUrl}));
        ((MainUIHandler)this.handler).reloadDbManagerText();
        ((MainUIHandler)this.handler).changeTitle();
    }

    public void postFailedAction(Throwable error) {
        ((MainUIHandler)this.handler).reloadDbManagerText();
        super.postFailedAction(error);
    }
}

