/*
 * *##% 
 * SuiviObsmer :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.suiviobsmer.ui.data;

import fr.ifremer.suiviobsmer.bean.ContactState;
import fr.ifremer.suiviobsmer.entity.Boat;
import fr.ifremer.suiviobsmer.entity.Contact;
import fr.ifremer.suiviobsmer.entity.FishingZone;
import fr.ifremer.suiviobsmer.entity.Profession;
import fr.ifremer.suiviobsmer.entity.SampleRow;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

/**
 * DataUtils
 *
 * Created: 3 déc. 2009
 *
 * @author fdesbois
 * @version $Revision$
 *
 * Mise a jour: $Date$
 * par : $Author$
 */
public class BusinessUtils {


    public static String getTooltipSampleRow(SampleRow row) {
        String result = "";
        DateFormat dateFormat = new SimpleDateFormat("MM/yyyy");
        Profession profession = row.getProfession();
        result += "<strong>Métier : </strong>" + profession.getCodeDCF5();
        if (!StringUtils.isEmpty(profession.getMeshSize())) {
            result+= " " + profession.getMeshSize();
        }
        if (!StringUtils.isEmpty(profession.getSize())) {
            result+= " " + profession.getSize();
        }
        if (!StringUtils.isEmpty(profession.getOther())) {
            result+= " " + profession.getOther();
        }
        result += " - " + profession.getLibelle();
        if (!StringUtils.isEmpty(profession.getSpecies())) {
            result += "<br /><strong>Espèces cibles : </strong>" + profession.getSpecies();
        }
        result += "<br /><strong>Programme : </strong>" + row.getProgramName();
        result += "<br /><strong>Période : </strong> du " + dateFormat.format(row.getPeriodBegin()) +
                " au " + dateFormat.format(row.getPeriodEnd());

        for (FishingZone zone : row.getFishingZone()) {
            result += "<br /><strong>Zone de pêche : </strong>" + zone.getCode();
        }

        return result;
    }

    public static String getTooltipBoat(Boat boat) {
        String result = "";
        result += "<strong>" + boat.getImmatriculation() + "</strong>";
        result += "<br /><strong>Quartier : </strong>" + boat.getDistrictCode();
        result += "<br /><strong>Longueur : </strong>" + boat.getBoatLength() + " m";
        result += "<br /><strong>Année de construction : </strong>" + boat.getBuildYear();
        return result;
    }

    public static String getCSSColorClassForContact(Contact contact, boolean admin) {
        String result = "";
        ContactState state = ContactState.createContactStateEnum(contact.getState());
        if (BooleanUtils.isFalse(contact.getValidationProgram()) ||
                (!admin && BooleanUtils.isFalse(contact.getValidationCompany()))) {
            result = "refused";
        } else if (BooleanUtils.isTrue(contact.getValidationProgram()) ||
                (!admin && BooleanUtils.isTrue(contact.getValidationCompany()))) {
            result = "accepted";
        } else if (state.isUnfinishedState()) {
            result = "unfinished";
        } else if (state.equals(ContactState.BOARDING_DONE)) {
            result = "even";
        } else {
            result = "odd";
        }
        return result;
    }
}
