/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RUtil {
    private static final Log log = LogFactory.getLog(RUtil.class);

    public static void initJri() {
        block7: {
            System.setProperty("R.type", "jni");
            try {
                ProcessBuilder pb = new ProcessBuilder("Rscript", "-e", "installed.packages()[which(installed.packages()[,1]=='rJava'),]['LibPath']");
                Process process = pb.start();
                int exitValue = process.waitFor();
                if (exitValue == 0) {
                    RUtil.parseRscriptOutput(process.getInputStream());
                } else {
                    InputStream err = process.getErrorStream();
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Can't call Rscript : " + IOUtils.toString((InputStream)err)));
                    }
                }
            }
            catch (IOException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Can't find R", (Throwable)ex);
                }
            }
            catch (InterruptedException ex) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Can't find R", (Throwable)ex);
            }
        }
    }

    protected static void parseRscriptOutput(InputStream is) throws IOException {
        List output = IOUtils.readLines((InputStream)is);
        if (output.size() != 1) {
            if (output.size() == 2) {
                String location = ((String)output.get(1)).trim();
                location = StringUtils.removeStart((String)location, (String)"\"");
                location = StringUtils.removeEnd((String)location, (String)"\"");
                location = location.replace('/', File.separatorChar);
                location = location + File.separator + "rJava" + File.separator + "jri";
                RUtil.setJavaLibraryPath(location);
            } else if (log.isErrorEnabled()) {
                log.error((Object)"Can't analyze Rscript output. was: ");
                for (String line : output) {
                    log.error((Object)line);
                }
            }
        }
    }

    protected static void setJavaLibraryPath(String newValue) {
        block3: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Adding '" + newValue + "' to java.library.path"));
            }
            System.setProperty("java.library.path", newValue);
            try {
                Field sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
                sysPathsField.setAccessible(true);
                sysPathsField.set(null, null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ex) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Cant' reset ClassLoader#sys_paths value", (Throwable)ex);
            }
        }
    }
}

