/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;

public class DependencyUtil {
    private static final Log log = LogFactory.getLog(DependencyUtil.class);

    public static Set<String> extractDependencies(File rootDirectory, Collection<File> files) {
        HashSet<String> deps = new HashSet<String>();
        HashSet<File> alreadyDone = new HashSet<File>();
        DependencyUtil.recursiveExtractDependencies(rootDirectory, files, alreadyDone, deps);
        return deps;
    }

    protected static void recursiveExtractDependencies(File rootDirectory, Collection<File> todoClassFiles, Set<File> alreadyDone, Set<String> deps) {
        for (File file : todoClassFiles) {
            alreadyDone.add(file);
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                Throwable throwable = null;
                try {
                    Set<String> fileDeps = DependencyUtil.extractDependencies(is);
                    deps.addAll(fileDeps);
                }
                catch (Throwable fileDeps) {
                    throwable = fileDeps;
                    throw fileDeps;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable fileDeps) {
                            throwable.addSuppressed(fileDeps);
                        }
                        continue;
                    }
                    ((InputStream)is).close();
                }
            }
            catch (IOException ex) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't extract dependencies", (Throwable)ex);
            }
        }
        ArrayList<File> newClassFiles = new ArrayList<File>();
        for (String dep : deps) {
            String classRelative = dep.replace('.', File.separatorChar) + ".class";
            File classFile = new File(rootDirectory, classRelative);
            if (alreadyDone.contains(classFile)) continue;
            newClassFiles.add(classFile);
        }
        if (!newClassFiles.isEmpty()) {
            DependencyUtil.recursiveExtractDependencies(rootDirectory, newClassFiles, alreadyDone, deps);
        }
    }

    protected static Set<String> extractDependencies(InputStream clazzStream) {
        HashSet<String> result;
        block2: {
            result = new HashSet<String>();
            final MethodVisitor mv = new MethodVisitor(327680){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    DependencyUtil.registerDescriptor(result, desc);
                    return super.visitAnnotation(desc, visible);
                }

                public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
                    DependencyUtil.registerDescriptor(result, desc);
                    return super.visitTypeAnnotation(typeRef, typePath, desc, visible);
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                    DependencyUtil.registerDescriptor(result, desc);
                    return super.visitParameterAnnotation(parameter, desc, visible);
                }

                public void visitTypeInsn(int opcode, String type) {
                    DependencyUtil.registerType(result, type);
                    super.visitTypeInsn(opcode, type);
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    DependencyUtil.registerType(result, owner);
                    DependencyUtil.registerDescriptor(result, desc);
                    super.visitFieldInsn(opcode, owner, name, desc);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    DependencyUtil.registerType(result, owner);
                    DependencyUtil.registerDescriptor(result, desc);
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }

                public void visitLdcInsn(Object cst) {
                    if (cst instanceof Type) {
                        DependencyUtil.registerType(result, ((Type)cst).getClassName());
                    }
                    super.visitLdcInsn(cst);
                }

                public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                    DependencyUtil.registerType(result, type);
                    super.visitTryCatchBlock(start, end, handler, type);
                }

                public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                    DependencyUtil.registerDescriptor(result, desc);
                    super.visitLocalVariable(name, desc, signature, start, end, index);
                }
            };
            ClassVisitor visitor = new ClassVisitor(327680){

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    DependencyUtil.registerType(result, superName);
                    super.visit(version, access, name, signature, superName, interfaces);
                }

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    DependencyUtil.registerDescriptor(result, desc);
                    return super.visitAnnotation(desc, visible);
                }

                public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                    DependencyUtil.registerDescriptor(result, desc);
                    return super.visitField(access, name, desc, signature, value);
                }

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    DependencyUtil.registerDescriptor(result, desc);
                    return mv;
                }
            };
            try {
                ClassReader classReader = new ClassReader(clazzStream);
                classReader.accept(visitor, 0);
            }
            catch (IOException ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't extract dependencies", (Throwable)ex);
            }
        }
        return result;
    }

    protected static void registerType(Set<String> types, String type) {
        if (StringUtils.startsWithAny((CharSequence)type, (CharSequence[])new CharSequence[]{"exports", "formules", "objectives", "optimizations", "rules", "resultinfos", "scripts", "sensitivityanalysis", "sensitivityexports", "simulationplans", "simulators"}) && !type.contains("$")) {
            String dotType = type.replace('/', '.');
            types.add(dotType);
        }
    }

    protected static void registerDescriptor(Set<String> types, String descriptor) {
        if (descriptor.startsWith("(")) {
            int endIndex = descriptor.indexOf(41);
            DependencyUtil.registerDescriptor(types, descriptor.substring(1, endIndex));
            DependencyUtil.registerDescriptor(types, descriptor.substring(endIndex + 1));
        } else {
            Pattern pattern = Pattern.compile("\\[*L([^;]+);");
            Matcher matcher = pattern.matcher(descriptor);
            while (matcher.find()) {
                String match = matcher.group(1);
                DependencyUtil.registerType(types, match);
            }
        }
    }
}

